/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.serialization.deserializers.body.BodyDTODeserializer;
import org.mockserver.serialization.deserializers.body.BodyWithContentTypeDTODeserializer;
import org.mockserver.serialization.deserializers.collections.CookiesDeserializer;
import org.mockserver.serialization.deserializers.collections.HeadersDeserializer;
import org.mockserver.serialization.deserializers.collections.ParametersDeserializer;
import org.mockserver.serialization.deserializers.condition.TimeToLiveDTODeserializer;
import org.mockserver.serialization.deserializers.condition.VerificationTimesDTODeserializer;
import org.mockserver.serialization.deserializers.expectation.OpenAPIExpectationDTODeserializer;
import org.mockserver.serialization.deserializers.request.RequestDefinitionDTODeserializer;
import org.mockserver.serialization.deserializers.string.NottableStringDeserializer;
import org.mockserver.serialization.serializers.body.BinaryBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.BinaryBodySerializer;
import org.mockserver.serialization.serializers.body.JsonBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.JsonBodySerializer;
import org.mockserver.serialization.serializers.body.JsonPathBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.JsonPathBodySerializer;
import org.mockserver.serialization.serializers.body.JsonSchemaBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.JsonSchemaBodySerializer;
import org.mockserver.serialization.serializers.body.LogEntryBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.LogEntryBodySerializer;
import org.mockserver.serialization.serializers.body.ParameterBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.ParameterBodySerializer;
import org.mockserver.serialization.serializers.body.RegexBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.RegexBodySerializer;
import org.mockserver.serialization.serializers.body.StringBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.StringBodySerializer;
import org.mockserver.serialization.serializers.body.XPathBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.XPathBodySerializer;
import org.mockserver.serialization.serializers.body.XmlBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.XmlBodySerializer;
import org.mockserver.serialization.serializers.body.XmlSchemaBodyDTOSerializer;
import org.mockserver.serialization.serializers.body.XmlSchemaBodySerializer;
import org.mockserver.serialization.serializers.certificate.X509CertificateSerializer;
import org.mockserver.serialization.serializers.collections.CookiesSerializer;
import org.mockserver.serialization.serializers.collections.HeadersSerializer;
import org.mockserver.serialization.serializers.collections.ParametersSerializer;
import org.mockserver.serialization.serializers.condition.VerificationTimesDTOSerializer;
import org.mockserver.serialization.serializers.condition.VerificationTimesSerializer;
import org.mockserver.serialization.serializers.expectation.OpenAPIExpectationDTOSerializer;
import org.mockserver.serialization.serializers.expectation.OpenAPIExpectationSerializer;
import org.mockserver.serialization.serializers.log.LogEntrySerializer;
import org.mockserver.serialization.serializers.matcher.HttpRequestPropertiesMatcherSerializer;
import org.mockserver.serialization.serializers.matcher.HttpRequestsPropertiesMatcherSerializer;
import org.mockserver.serialization.serializers.request.HttpRequestDTOSerializer;
import org.mockserver.serialization.serializers.request.HttpRequestSerializer;
import org.mockserver.serialization.serializers.request.OpenAPIDefinitionDTOSerializer;
import org.mockserver.serialization.serializers.request.OpenAPIDefinitionSerializer;
import org.mockserver.serialization.serializers.response.HttpResponseDTOSerializer;
import org.mockserver.serialization.serializers.response.HttpResponseSerializer;
import org.mockserver.serialization.serializers.response.TimeToLiveDTOSerializer;
import org.mockserver.serialization.serializers.response.TimeToLiveSerializer;
import org.mockserver.serialization.serializers.response.TimesDTOSerializer;
import org.mockserver.serialization.serializers.response.TimesSerializer;
import org.mockserver.serialization.serializers.schema.ArraySchemaSerializer;
import org.mockserver.serialization.serializers.schema.BinarySchemaSerializer;
import org.mockserver.serialization.serializers.schema.BooleanSchemaSerializer;
import org.mockserver.serialization.serializers.schema.ByteArraySchemaSerializer;
import org.mockserver.serialization.serializers.schema.ComposedSchemaSerializer;
import org.mockserver.serialization.serializers.schema.DateSchemaSerializer;
import org.mockserver.serialization.serializers.schema.DateTimeSchemaSerializer;
import org.mockserver.serialization.serializers.schema.EmailSchemaSerializer;
import org.mockserver.serialization.serializers.schema.FileSchemaSerializer;
import org.mockserver.serialization.serializers.schema.IntegerSchemaSerializer;
import org.mockserver.serialization.serializers.schema.MapSchemaSerializer;
import org.mockserver.serialization.serializers.schema.NumberSchemaSerializer;
import org.mockserver.serialization.serializers.schema.ObjectSchemaSerializer;
import org.mockserver.serialization.serializers.schema.PasswordSchemaSerializer;
import org.mockserver.serialization.serializers.schema.SchemaSerializer;
import org.mockserver.serialization.serializers.schema.StringSchemaSerializer;
import org.mockserver.serialization.serializers.schema.UUIDSchemaSerializer;
import org.mockserver.serialization.serializers.string.NottableStringSerializer;

public class ObjectMapperFactory {
    private static ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList());
    private static final ObjectWriter prettyPrintWriter = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList()).writerWithDefaultPrettyPrinter();
    private static final ObjectWriter writer = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList()).writer();

    public static ObjectMapper createObjectMapper() {
        if (objectMapper == null) {
            objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList());
        }
        return objectMapper;
    }

    public static ObjectMapper createObjectMapper(JsonSerializer ... additionJsonSerializers) {
        if (additionJsonSerializers == null || additionJsonSerializers.length == 0) {
            if (objectMapper == null) {
                objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList());
            }
            return objectMapper;
        }
        return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Arrays.asList(additionJsonSerializers));
    }

    public static ObjectMapper createObjectMapper(JsonDeserializer ... replacementJsonDeserializers) {
        if (replacementJsonDeserializers == null || replacementJsonDeserializers.length == 0) {
            if (objectMapper == null) {
                objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList());
            }
            return objectMapper;
        }
        return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Arrays.asList(replacementJsonDeserializers), Collections.emptyList());
    }

    public static ObjectWriter createObjectMapper(boolean pretty, JsonSerializer ... additionJsonSerializers) {
        if (additionJsonSerializers == null || additionJsonSerializers.length == 0) {
            if (pretty) {
                return prettyPrintWriter;
            }
            return writer;
        }
        if (pretty) {
            return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Arrays.asList(additionJsonSerializers)).writerWithDefaultPrettyPrinter();
        }
        return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Arrays.asList(additionJsonSerializers)).writer();
    }

    public static ObjectMapper buildObjectMapperWithoutRemovingEmptyValues() {
        ObjectMapper objectMapper = new ObjectMapper();
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(MapperFeature.ALLOW_COERCION_OF_SCALARS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, false));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_MISSING_VALUES, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true));
        ExceptionHandling.swallowThrowable(() -> objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true));
        return objectMapper;
    }

    public static ObjectMapper buildObjectMapperWithOnlyConfigurationDefaults() {
        ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapperWithoutRemovingEmptyValues();
        ExceptionHandling.swallowThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT));
        ExceptionHandling.swallowThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL));
        ExceptionHandling.swallowThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY));
        return objectMapper;
    }

    private static ObjectMapper buildObjectMapperWithDeserializerAndSerializers(List<JsonDeserializer> replacementJsonDeserializers, List<JsonSerializer> replacementJsonSerializers) {
        ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapperWithOnlyConfigurationDefaults();
        SimpleModule module = new SimpleModule();
        ObjectMapperFactory.addDeserializers(module, replacementJsonDeserializers.toArray(new JsonDeserializer[0]));
        ObjectMapperFactory.addSerializers(module, replacementJsonSerializers.toArray(new JsonSerializer[0]));
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    private static void addDeserializers(SimpleModule module, JsonDeserializer[] replacementJsonDeserializers) {
        List<JsonDeserializer> jsonDeserializers = Arrays.asList(new JsonDeserializer[]{new OpenAPIExpectationDTODeserializer(), new RequestDefinitionDTODeserializer(), new TimeToLiveDTODeserializer(), new BodyDTODeserializer(), new BodyWithContentTypeDTODeserializer(), new VerificationTimesDTODeserializer(), new NottableStringDeserializer(), new HeadersDeserializer(), new ParametersDeserializer(), new CookiesDeserializer()});
        HashMap<Class, JsonDeserializer> jsonDeserializersByType = new HashMap<Class, JsonDeserializer>();
        for (JsonDeserializer jsonDeserializer : jsonDeserializers) {
            jsonDeserializersByType.put(jsonDeserializer.handledType(), jsonDeserializer);
        }
        for (JsonDeserializer additionJsonDeserializer : replacementJsonDeserializers) {
            jsonDeserializersByType.put(additionJsonDeserializer.handledType(), additionJsonDeserializer);
        }
        for (Map.Entry entry : jsonDeserializersByType.entrySet()) {
            module.addDeserializer((Class)entry.getKey(), (JsonDeserializer)entry.getValue());
        }
    }

    private static void addSerializers(SimpleModule module, JsonSerializer[] replacementJsonSerializers) {
        List<JsonSerializer> jsonSerializers = Arrays.asList(new JsonSerializer[]{new OpenAPIExpectationSerializer(), new OpenAPIExpectationDTOSerializer(), new TimesSerializer(), new TimesDTOSerializer(), new TimeToLiveSerializer(), new TimeToLiveDTOSerializer(), new HttpRequestSerializer(), new HttpRequestDTOSerializer(), new OpenAPIDefinitionSerializer(), new OpenAPIDefinitionDTOSerializer(), new BinaryBodySerializer(), new BinaryBodyDTOSerializer(), new JsonBodySerializer(), new JsonBodyDTOSerializer(), new JsonSchemaBodySerializer(), new JsonSchemaBodyDTOSerializer(), new JsonPathBodySerializer(), new JsonPathBodyDTOSerializer(), new ParameterBodySerializer(), new ParameterBodyDTOSerializer(), new RegexBodySerializer(), new RegexBodyDTOSerializer(), new StringBodySerializer(), new StringBodyDTOSerializer(), new XmlBodySerializer(), new XmlBodyDTOSerializer(), new XmlSchemaBodySerializer(), new XmlSchemaBodyDTOSerializer(), new XPathBodySerializer(), new XPathBodyDTOSerializer(), new LogEntryBodySerializer(), new LogEntryBodyDTOSerializer(), new VerificationTimesDTOSerializer(), new VerificationTimesSerializer(), new NottableStringSerializer(), new HttpResponseSerializer(), new HttpResponseDTOSerializer(), new HeadersSerializer(), new ParametersSerializer(), new CookiesSerializer(), new X509CertificateSerializer(), new LogEntrySerializer(), new HttpRequestsPropertiesMatcherSerializer(), new HttpRequestPropertiesMatcherSerializer(), new SchemaSerializer(), new ArraySchemaSerializer(), new BinarySchemaSerializer(), new BooleanSchemaSerializer(), new ByteArraySchemaSerializer(), new ComposedSchemaSerializer(), new DateSchemaSerializer(), new DateTimeSchemaSerializer(), new EmailSchemaSerializer(), new FileSchemaSerializer(), new IntegerSchemaSerializer(), new MapSchemaSerializer(), new NumberSchemaSerializer(), new ObjectSchemaSerializer(), new PasswordSchemaSerializer(), new StringSchemaSerializer(), new UUIDSchemaSerializer()});
        HashMap<Class, JsonSerializer> jsonSerializersByType = new HashMap<Class, JsonSerializer>();
        for (JsonSerializer jsonSerializer : jsonSerializers) {
            jsonSerializersByType.put(jsonSerializer.handledType(), jsonSerializer);
        }
        for (JsonSerializer additionJsonSerializer : replacementJsonSerializers) {
            jsonSerializersByType.put(additionJsonSerializer.handledType(), additionJsonSerializer);
        }
        for (Map.Entry entry : jsonSerializersByType.entrySet()) {
            module.addSerializer((Class)entry.getKey(), (JsonSerializer)entry.getValue());
        }
    }
}

