/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.Map;
import java.util.Objects;
import org.mockserver.file.FileReader;
import org.mockserver.model.Body;
import org.mockserver.model.ParameterStyle;

public class JsonSchemaBody
extends Body<String> {
    private int hashCode;
    private final String jsonSchema;
    private Map<String, ParameterStyle> parameterStyles;

    public JsonSchemaBody(String jsonSchema) {
        super(Body.Type.JSON_SCHEMA);
        this.jsonSchema = jsonSchema;
    }

    public static JsonSchemaBody jsonSchema(String jsonSchema) {
        return new JsonSchemaBody(jsonSchema);
    }

    public static JsonSchemaBody jsonSchemaFromResource(String jsonSchemaPath) {
        return new JsonSchemaBody(FileReader.readFileFromClassPathOrPath(jsonSchemaPath));
    }

    public Map<String, ParameterStyle> getParameterStyles() {
        return this.parameterStyles;
    }

    public JsonSchemaBody withParameterStyles(Map<String, ParameterStyle> parameterStyles) {
        this.parameterStyles = parameterStyles;
        return this;
    }

    @Override
    public String getValue() {
        return this.jsonSchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonSchemaBody that = (JsonSchemaBody)o;
        return Objects.equals(this.jsonSchema, that.jsonSchema);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.jsonSchema);
        }
        return this.hashCode;
    }
}

