/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server.initialize;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.cache.LRUCache;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.server.initialize.ExpectationInitializer;
import org.slf4j.event.Level;

public class ExpectationInitializerLoader {
    private static final LRUCache<String, List<String>> EXPANDED_INITIALIZATION_JSON_PATHS = new LRUCache(new MockServerLogger(LRUCache.class), 10, TimeUnit.HOURS.toMillis(1L));
    private final ExpectationSerializer expectationSerializer;
    private final MockServerLogger mockServerLogger;
    private final RequestMatchers requestMatchers;

    public ExpectationInitializerLoader(MockServerLogger mockServerLogger, RequestMatchers requestMatchers) {
        this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.requestMatchers = requestMatchers;
        this.addExpectationsFromInitializer();
    }

    public static List<String> expandedInitializationJsonPaths() {
        List<String> expandedInitializationJsonPaths = EXPANDED_INITIALIZATION_JSON_PATHS.get(ConfigurationProperties.initializationJsonPath());
        if (expandedInitializationJsonPaths == null) {
            expandedInitializationJsonPaths = FileReader.expandFilePathGlobs(ConfigurationProperties.initializationJsonPath());
            EXPANDED_INITIALIZATION_JSON_PATHS.put(ConfigurationProperties.initializationJsonPath(), expandedInitializationJsonPaths);
        }
        return expandedInitializationJsonPaths;
    }

    private void addExpectationsFromInitializer() {
        this.retrieveExpectationsFromJson();
        for (Expectation expectation : this.retrieveExpectationsFromInitializerClass()) {
            this.requestMatchers.add(expectation, new MockServerMatcherNotifier.Cause("", MockServerMatcherNotifier.Cause.Type.CLASS_INITIALISER));
        }
    }

    private Expectation[] retrieveExpectationsFromInitializerClass() {
        Expectation[] expectations;
        block7: {
            expectations = new Expectation[]{};
            String initializationClass = ConfigurationProperties.initializationClass();
            try {
                if (StringUtils.isNotBlank((CharSequence)initializationClass)) {
                    Constructor<?> initializerClassConstructor;
                    Object expectationInitializer;
                    ClassLoader contextClassLoader;
                    if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setMessageFormat("loading class initialization file:{}").setArguments(initializationClass));
                    }
                    if ((contextClassLoader = ExpectationInitializerLoader.class.getClassLoader()) != null && StringUtils.isNotBlank((CharSequence)initializationClass) && (expectationInitializer = (initializerClassConstructor = contextClassLoader.loadClass(initializationClass).getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                        expectations = ((ExpectationInitializer)expectationInitializer).initializeExpectations();
                    }
                }
                if (expectations.length > 0) {
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded expectations:{}from class:{}").setArguments(Arrays.asList(expectations), initializationClass));
                    }
                    this.requestMatchers.update(expectations, new MockServerMatcherNotifier.Cause(initializationClass, MockServerMatcherNotifier.Cause.Type.CLASS_INITIALISER));
                }
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled(Level.WARN)) break block7;
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.WARN).setMessageFormat("exception while loading JSON initialization class, ignoring class:{}").setArguments(initializationClass).setThrowable(throwable));
            }
        }
        return expectations;
    }

    private Expectation[] retrieveExpectationsFromJson() {
        List<String> initializationJsonPaths = ExpectationInitializerLoader.expandedInitializationJsonPaths();
        List<Expectation> collect = initializationJsonPaths.stream().flatMap(initializationJsonPath -> {
            Expectation[] expectations;
            block7: {
                expectations = new Expectation[]{};
                if (StringUtils.isNotBlank((CharSequence)initializationJsonPath)) {
                    if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setMessageFormat("loading JSON initialization file:{}").setArguments(initializationJsonPath));
                    }
                    try {
                        String jsonExpectations = FileReader.readFileFromClassPathOrPath(initializationJsonPath);
                        if (StringUtils.isNotBlank((CharSequence)jsonExpectations)) {
                            expectations = this.expectationSerializer.deserializeArray(jsonExpectations, true);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!MockServerLogger.isEnabled(Level.WARN)) break block7;
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.WARN).setMessageFormat("exception while loading JSON initialization file, ignoring file:{}").setArguments(initializationJsonPath).setThrowable(throwable));
                    }
                }
            }
            if (expectations.length > 0) {
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded expectations:{}from file:{}").setArguments(Arrays.asList(expectations), initializationJsonPath));
                }
                this.requestMatchers.update(expectations, new MockServerMatcherNotifier.Cause((String)initializationJsonPath, MockServerMatcherNotifier.Cause.Type.FILE_INITIALISER));
            }
            return Arrays.stream(expectations);
        }).collect(Collectors.toList());
        return collect.toArray(new Expectation[0]);
    }

    @VisibleForTesting
    public Expectation[] loadExpectations() {
        Object[] expectationsFromInitializerClass = this.retrieveExpectationsFromInitializerClass();
        Object[] expectationsFromJson = this.retrieveExpectationsFromJson();
        return (Expectation[])ArrayUtils.addAll((Object[])expectationsFromInitializerClass, (Object[])expectationsFromJson);
    }
}

