/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.VerificationSequenceDTO;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;
import org.mockserver.validator.jsonschema.JsonSchemaVerificationSequenceValidator;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.event.Level;

public class VerificationSequenceSerializer
implements Serializer<VerificationSequence> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonSchemaVerificationSequenceValidator verificationSequenceValidator;

    public VerificationSequenceSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    private JsonSchemaVerificationSequenceValidator getValidator() {
        if (this.verificationSequenceValidator == null) {
            this.verificationSequenceValidator = JsonSchemaVerificationSequenceValidator.jsonSchemaVerificationSequenceValidator(this.mockServerLogger);
        }
        return this.verificationSequenceValidator;
    }

    @Override
    public String serialize(VerificationSequence verificationSequence) {
        try {
            return this.objectWriter.writeValueAsString((Object)new VerificationSequenceDTO(verificationSequence));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing verificationSequence to JSON with value " + verificationSequence).setThrowable(e));
            throw new RuntimeException("Exception while serializing verificationSequence to JSON with value " + verificationSequence, e);
        }
    }

    @Override
    public VerificationSequence deserialize(String jsonVerificationSequence) {
        if (StringUtils.isBlank((CharSequence)jsonVerificationSequence)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a verification sequence is required but value was \"" + jsonVerificationSequence + "\"" + Character.NEW_LINE + Character.NEW_LINE + JsonSchemaValidator.OPEN_API_SPECIFICATION_URL);
        }
        String validationErrors = this.getValidator().isValid(jsonVerificationSequence);
        if (validationErrors.isEmpty()) {
            VerificationSequence verificationSequence = null;
            try {
                VerificationSequenceDTO verificationDTO = (VerificationSequenceDTO)this.objectMapper.readValue(jsonVerificationSequence, VerificationSequenceDTO.class);
                if (verificationDTO != null) {
                    verificationSequence = verificationDTO.buildObject();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for VerificationSequence " + throwable.getMessage()).setArguments(jsonVerificationSequence).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonVerificationSequence + "] for VerificationSequence", throwable);
            }
            return verificationSequence;
        }
        throw new IllegalArgumentException(StringUtils.removeEndIgnoreCase((String)StringFormatter.formatLogMessage("incorrect verification sequence json format for:{}schema validation errors:{}", jsonVerificationSequence, validationErrors), (String)"\n"));
    }

    @Override
    public Class<VerificationSequence> supportsType() {
        return VerificationSequence.class;
    }
}

