/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.persistence;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.persistence.FileWatcher;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.server.initialize.ExpectationInitializerLoader;
import org.slf4j.event.Level;

public class ExpectationFileWatcher {
    private final ExpectationSerializer expectationSerializer;
    private final MockServerLogger mockServerLogger;
    private final RequestMatchers requestMatchers;
    private List<FileWatcher> fileWatchers;

    public ExpectationFileWatcher(MockServerLogger mockServerLogger, RequestMatchers requestMatchers) {
        if (ConfigurationProperties.watchInitializationJson()) {
            this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
            this.mockServerLogger = mockServerLogger;
            this.requestMatchers = requestMatchers;
            List<String> initializationJsonPaths = ExpectationInitializerLoader.expandedInitializationJsonPaths();
            try {
                this.fileWatchers = initializationJsonPaths.stream().map(initializationJsonPath -> {
                    try {
                        return new FileWatcher(Paths.get(initializationJsonPath, new String[0]), () -> {
                            if (MockServerLogger.isEnabled(Level.DEBUG)) {
                                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("expectation file watcher updating expectations as modification detected on file{}").setArguments(ConfigurationProperties.initializationJsonPath()));
                            }
                            this.addExpectationsFromInitializer();
                        }, throwable -> {
                            if (MockServerLogger.isEnabled(Level.WARN)) {
                                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception while processing expectation file update " + throwable.getMessage()).setThrowable((Throwable)throwable));
                            }
                        }, mockServerLogger);
                    }
                    catch (Throwable throwable2) {
                        mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception creating file watcher for{}").setArguments(initializationJsonPath).setThrowable(throwable2));
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception creating file watchers for{}").setArguments(initializationJsonPaths).setThrowable(throwable));
            }
            if (MockServerLogger.isEnabled(Level.INFO)) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("created expectation file watcher for{}").setArguments(initializationJsonPaths));
            }
        } else {
            this.expectationSerializer = null;
            this.mockServerLogger = null;
            this.requestMatchers = null;
        }
    }

    private synchronized void addExpectationsFromInitializer() {
        ExpectationInitializerLoader.expandedInitializationJsonPaths().forEach(initializationJsonPath -> {
            Expectation[] expectations;
            block5: {
                expectations = new Expectation[]{};
                if (StringUtils.isNotBlank((CharSequence)initializationJsonPath)) {
                    try {
                        String jsonExpectations = FileReader.readFileFromClassPathOrPath(initializationJsonPath);
                        if (StringUtils.isNotBlank((CharSequence)jsonExpectations)) {
                            expectations = this.expectationSerializer.deserializeArray(jsonExpectations, true);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!MockServerLogger.isEnabled(Level.WARN)) break block5;
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.WARN).setMessageFormat("exception while loading JSON initialization file with file watcher, ignoring file:{}").setArguments(initializationJsonPath).setThrowable(throwable));
                    }
                }
            }
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("updating expectations:{}from file:{}").setArguments(Arrays.asList(expectations), initializationJsonPath));
            }
            this.requestMatchers.update(expectations, new MockServerMatcherNotifier.Cause((String)initializationJsonPath, MockServerMatcherNotifier.Cause.Type.FILE_WATCHER));
        });
    }

    public void stop() {
        if (this.fileWatchers != null) {
            this.fileWatchers.forEach(fileWatcher -> fileWatcher.setRunning(false));
        }
    }
}

