/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi;

import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.openapi.OpenAPIParser;
import org.mockserver.openapi.examples.ExampleBuilder;
import org.mockserver.openapi.examples.JsonNodeExampleSerializer;
import org.mockserver.openapi.examples.models.Example;
import org.mockserver.openapi.examples.models.StringExample;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class OpenAPIConverter {
    private static final ObjectWriter OBJECT_WRITER = ObjectMapperFactory.createObjectMapper(new JsonNodeExampleSerializer()).writerWithDefaultPrettyPrinter();
    private final MockServerLogger mockServerLogger;

    public OpenAPIConverter(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public List<Expectation> buildExpectations(String specUrlOrPayload, Map<String, String> operationsAndResponses) {
        OpenAPI openAPI = OpenAPIParser.buildOpenAPI(specUrlOrPayload, this.mockServerLogger);
        AtomicInteger expectationCounter = new AtomicInteger(0);
        return openAPI.getPaths().values().stream().flatMap(pathItem -> pathItem.readOperations().stream()).filter(operation -> operationsAndResponses == null || operationsAndResponses.containsKey(operation.getOperationId())).map(operation -> new Expectation(OpenAPIDefinition.openAPI(specUrlOrPayload, operation.getOperationId())).thenRespond(this.buildHttpResponse(openAPI, operation.getResponses(), operationsAndResponses != null ? (String)operationsAndResponses.get(operation.getOperationId()) : null))).map(expectation -> {
            int index = expectationCounter.incrementAndGet();
            return expectation.withId(new UUID((long)Objects.hash(specUrlOrPayload, operationsAndResponses) * (long)index, (long)Objects.hash(specUrlOrPayload, operationsAndResponses) * (long)index).toString());
        }).collect(Collectors.toList());
    }

    private HttpResponse buildHttpResponse(OpenAPI openAPI, ApiResponses apiResponses, String apiResponseKey) {
        HttpResponse response = HttpResponse.response();
        Optional.ofNullable(apiResponses).flatMap(notNullApiResponses -> notNullApiResponses.entrySet().stream().filter(entry -> StringUtils.isBlank((CharSequence)apiResponseKey) | ((String)entry.getKey()).equals(apiResponseKey)).findFirst()).ifPresent(apiResponse -> {
            if (!((String)apiResponse.getKey()).equalsIgnoreCase("default")) {
                response.withStatusCode(Integer.parseInt((String)apiResponse.getKey()));
            }
            Optional.ofNullable(((ApiResponse)apiResponse.getValue()).getHeaders()).map(Map::entrySet).map(Collection::stream).ifPresent(stream -> stream.forEach(entry -> {
                Header value = (Header)entry.getValue();
                io.swagger.v3.oas.models.examples.Example example = this.findExample(value);
                if (example != null) {
                    response.withHeader((String)entry.getKey(), String.valueOf(example.getValue()));
                } else if (value.getSchema() != null) {
                    Example generatedExample = ExampleBuilder.fromSchema(value.getSchema(), openAPI.getComponents().getSchemas());
                    if (generatedExample instanceof StringExample) {
                        response.withHeader((String)entry.getKey(), ((StringExample)generatedExample).getValue());
                    } else {
                        response.withHeader((String)entry.getKey(), this.serialise(generatedExample));
                    }
                }
            }));
            Optional.ofNullable(((ApiResponse)apiResponse.getValue()).getContent()).flatMap(content -> content.entrySet().stream().findFirst()).ifPresent(contentType -> {
                response.withHeader("content-type", (String)contentType.getKey());
                Optional.ofNullable(contentType.getValue()).ifPresent(mediaType -> {
                    io.swagger.v3.oas.models.examples.Example example = this.findExample((io.swagger.v3.oas.models.media.MediaType)mediaType);
                    if (example != null) {
                        if (OpenAPIConverter.isJsonContentType((String)contentType.getKey())) {
                            response.withBody(JsonBody.json(this.serialise(example.getValue())));
                        } else {
                            response.withBody(String.valueOf(example.getValue()));
                        }
                    } else if (mediaType.getSchema() != null) {
                        Example generatedExample = ExampleBuilder.fromSchema(mediaType.getSchema(), openAPI.getComponents().getSchemas());
                        if (generatedExample instanceof StringExample) {
                            if (OpenAPIConverter.isJsonContentType((String)contentType.getKey())) {
                                response.withBody(JsonBody.json(this.serialise(((StringExample)generatedExample).getValue())));
                            } else {
                                response.withBody(((StringExample)generatedExample).getValue());
                            }
                        } else {
                            String serialise = this.serialise(ExampleBuilder.fromSchema(mediaType.getSchema(), openAPI.getComponents().getSchemas()));
                            if (OpenAPIConverter.isJsonContentType((String)contentType.getKey())) {
                                response.withBody(JsonBody.json(serialise));
                            } else {
                                response.withBody(serialise);
                            }
                        }
                    }
                });
            });
        });
        return response;
    }

    public static boolean isJsonContentType(String contentType) {
        return MediaType.parse(contentType).isJson();
    }

    private io.swagger.v3.oas.models.examples.Example findExample(Header value) {
        io.swagger.v3.oas.models.examples.Example example = null;
        if (value.getExample() instanceof io.swagger.v3.oas.models.examples.Example) {
            example = (io.swagger.v3.oas.models.examples.Example)value.getExample();
        } else if (value.getExamples() != null && !value.getExamples().isEmpty()) {
            example = value.getExamples().values().stream().findFirst().orElse(null);
        }
        return example;
    }

    private io.swagger.v3.oas.models.examples.Example findExample(io.swagger.v3.oas.models.media.MediaType mediaType) {
        io.swagger.v3.oas.models.examples.Example example = null;
        if (mediaType.getExample() instanceof io.swagger.v3.oas.models.examples.Example) {
            example = (io.swagger.v3.oas.models.examples.Example)mediaType.getExample();
        } else if (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty()) {
            example = mediaType.getExamples().values().stream().findFirst().orElse(null);
        }
        return example;
    }

    private String serialise(Object example) {
        try {
            return OBJECT_WRITER.writeValueAsString(example);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serialising " + example.getClass() + " {}").setArguments(example).setThrowable(throwable));
            return "";
        }
    }
}

