/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.log;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.collections.CircularConcurrentLinkedDeque;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.listeners.MockServerEventLogNotifier;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.LogEventRequestAndResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.RequestDefinitionSerializer;
import org.mockserver.uuid.UUIDService;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MockServerEventLog
extends MockServerEventLogNotifier {
    private static final Logger logger = LoggerFactory.getLogger(MockServerEventLog.class);
    private static final Predicate<LogEntry> allPredicate = input -> true;
    private static final Predicate<LogEntry> notDeletedPredicate = input -> !input.isDeleted();
    private static final Predicate<LogEntry> requestLogPredicate = input -> !input.isDeleted() && input.getType() == LogEntry.LogMessageType.RECEIVED_REQUEST;
    private static final Predicate<LogEntry> requestResponseLogPredicate = input -> !input.isDeleted() && (input.getType() == LogEntry.LogMessageType.EXPECTATION_RESPONSE || input.getType() == LogEntry.LogMessageType.NO_MATCH_RESPONSE || input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST);
    private static final Predicate<LogEntry> recordedExpectationLogPredicate = input -> !input.isDeleted() && input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST;
    private static final Function<LogEntry, RequestDefinition[]> logEntryToRequest = LogEntry::getHttpRequests;
    private static final Function<LogEntry, Expectation> logEntryToExpectation = LogEntry::getExpectation;
    private static final Function<LogEntry, LogEventRequestAndResponse> logEntryToHttpRequestAndHttpResponse = logEntry -> new LogEventRequestAndResponse().withHttpRequest(logEntry.getHttpRequest()).withHttpResponse(logEntry.getHttpResponse()).withTimestamp(logEntry.getTimestamp());
    private static final String[] EXCLUDED_FIELDS = new String[]{"id", "disruptor"};
    private MockServerLogger mockServerLogger;
    private CircularConcurrentLinkedDeque<LogEntry> eventLog = new CircularConcurrentLinkedDeque<LogEntry>(ConfigurationProperties.maxLogEntries(), LogEntry::clear);
    private MatcherBuilder matcherBuilder;
    private RequestDefinitionSerializer requestDefinitionSerializer;
    private final boolean asynchronousEventProcessing;
    private Disruptor<LogEntry> disruptor;

    public MockServerEventLog(MockServerLogger mockServerLogger, Scheduler scheduler, boolean asynchronousEventProcessing) {
        super(scheduler);
        this.mockServerLogger = mockServerLogger;
        this.matcherBuilder = new MatcherBuilder(mockServerLogger);
        this.requestDefinitionSerializer = new RequestDefinitionSerializer(mockServerLogger);
        this.asynchronousEventProcessing = asynchronousEventProcessing;
        this.startRingBuffer();
    }

    public void add(LogEntry logEntry) {
        logEntry.setPort(HttpState.getPort());
        if (this.asynchronousEventProcessing) {
            if (!this.disruptor.getRingBuffer().tryPublishEvent((EventTranslator)logEntry) && logEntry.getLogLevel().toInt() >= Level.WARN.toInt()) {
                logger.warn("Too many log events failed to add log event to ring buffer: " + logEntry);
            }
        } else {
            this.processLogEntry(logEntry);
        }
    }

    public int size() {
        return this.eventLog.size();
    }

    public void setMaxSize(int maxSize) {
        this.eventLog.setMaxSize(maxSize);
    }

    private void startRingBuffer() {
        this.disruptor = new Disruptor(LogEntry::new, ConfigurationProperties.ringBufferSize(), (ThreadFactory)new Scheduler.SchedulerThreadFactory("EventLog"));
        ExceptionHandler<LogEntry> errorHandler = new ExceptionHandler<LogEntry>(){

            public void handleEventException(Throwable ex, long sequence, LogEntry logEntry) {
                logger.error("exception handling log entry in log ring buffer, for log entry: " + logEntry, ex);
            }

            public void handleOnStartException(Throwable ex) {
                logger.error("exception starting log ring buffer", ex);
            }

            public void handleOnShutdownException(Throwable ex) {
                logger.error("exception during shutdown of log ring buffer", ex);
            }
        };
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)errorHandler);
        this.disruptor.handleEventsWith(new EventHandler[]{(logEntry, sequence, endOfBatch) -> {
            if (logEntry.getType() != LogEntry.LogMessageType.RUNNABLE) {
                this.processLogEntry((LogEntry)logEntry);
            } else {
                logEntry.getConsumer().run();
            }
        }});
        this.disruptor.start();
    }

    private void processLogEntry(LogEntry logEntry) {
        logEntry = logEntry.cloneAndClear();
        this.eventLog.add(logEntry);
        this.notifyListeners(this, false);
        MockServerLogger.writeToSystemOut(logger, logEntry);
    }

    public void stop() {
        block2: {
            try {
                this.notifyListeners(this, true);
                this.eventLog.clear();
                this.disruptor.shutdown(2L, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                if (throwable instanceof TimeoutException || !MockServerLogger.isEnabled(Level.WARN)) break block2;
                MockServerLogger.writeToSystemOut(logger, new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception while shutting down log ring buffer").setThrowable(throwable));
            }
        }
    }

    public void reset() {
        CompletableFuture future = new CompletableFuture();
        this.disruptor.publishEvent((EventTranslator)new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            this.eventLog.clear();
            future.complete("done");
            this.notifyListeners(this, false);
        }));
        try {
            future.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | java.util.concurrent.TimeoutException exception) {
            // empty catch block
        }
    }

    public void clear(RequestDefinition requestDefinition) {
        CompletableFuture future = new CompletableFuture();
        boolean markAsDeletedOnly = MockServerLogger.isEnabled(Level.INFO);
        this.disruptor.publishEvent((EventTranslator)new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            String logCorrelationId = UUIDService.getUUID();
            RequestDefinition matcher = requestDefinition != null ? requestDefinition : HttpRequest.request().withLogCorrelationId(logCorrelationId);
            HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(matcher);
            for (LogEntry logEntry : new LinkedList<LogEntry>(this.eventLog)) {
                RequestDefinition[] requests = logEntry.getHttpRequests();
                boolean matches = false;
                if (requests != null) {
                    for (RequestDefinition request : requests) {
                        if (!requestMatcher.matches(request.cloneWithLogCorrelationId())) continue;
                        matches = true;
                    }
                } else {
                    matches = true;
                }
                if (!matches) continue;
                if (markAsDeletedOnly) {
                    logEntry.setDeleted(true);
                    continue;
                }
                this.eventLog.removeItem(logEntry);
            }
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(requestDefinition).setMessageFormat("cleared logs that match:{}").setArguments(requestDefinition == null ? "{}" : requestDefinition));
            }
            future.complete("done");
            this.notifyListeners(this, false);
        }));
        try {
            future.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | java.util.concurrent.TimeoutException exception) {
            // empty catch block
        }
    }

    public void retrieveMessageLogEntries(RequestDefinition requestDefinition, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, notDeletedPredicate, logEventStream -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public void retrieveMessageLogEntriesIncludingDeleted(RequestDefinition requestDefinition, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, allPredicate, logEventStream -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public void retrieveRequestLogEntries(RequestDefinition requestDefinition, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, requestLogPredicate, logEventStream -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public void retrieveRequests(RequestDefinition requestDefinition, Consumer<List<RequestDefinition>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, requestLogPredicate, logEntryToRequest, logEventStream -> listConsumer.accept(logEventStream.filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.toList())));
    }

    public void retrieveRequestResponseMessageLogEntries(RequestDefinition requestDefinition, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, requestResponseLogPredicate, logEventStream -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public void retrieveRequestResponses(RequestDefinition requestDefinition, Consumer<List<LogEventRequestAndResponse>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, requestResponseLogPredicate, logEntryToHttpRequestAndHttpResponse, logEventStream -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public void retrieveRecordedExpectationLogEntries(RequestDefinition requestDefinition, Consumer<List<LogEntry>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, recordedExpectationLogPredicate, logEventStream -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public void retrieveRecordedExpectations(RequestDefinition requestDefinition, Consumer<List<Expectation>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, recordedExpectationLogPredicate, logEntryToExpectation, logEventStream -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    private void retrieveLogEntries(RequestDefinition requestDefinition, Predicate<LogEntry> logEntryPredicate, Consumer<Stream<LogEntry>> consumer) {
        this.disruptor.publishEvent((EventTranslator)new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
            consumer.accept(this.eventLog.stream().filter(logItem -> logItem.matches(httpRequestMatcher)).filter(logEntryPredicate));
        }));
    }

    private <T> void retrieveLogEntries(RequestDefinition requestDefinition, Predicate<LogEntry> logEntryPredicate, Function<LogEntry, T> logEntryMapper, Consumer<Stream<T>> consumer) {
        this.disruptor.publishEvent((EventTranslator)new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            RequestDefinition requestDefinitionMatcher = requestDefinition != null ? requestDefinition : HttpRequest.request().withLogCorrelationId(UUIDService.getUUID());
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinitionMatcher);
            consumer.accept(this.eventLog.stream().filter(logItem -> logItem.matches(httpRequestMatcher)).filter(logEntryPredicate).map(logEntryMapper));
        }));
    }

    public <T> void retrieveLogEntriesInReverseForUI(RequestDefinition requestDefinition, Predicate<LogEntry> logEntryPredicate, Function<LogEntry, T> logEntryMapper, Consumer<Stream<T>> consumer) {
        this.disruptor.publishEvent((EventTranslator)new LogEntry().setType(LogEntry.LogMessageType.RUNNABLE).setConsumer(() -> {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
            consumer.accept(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.eventLog.descendingIterator(), 0), false).filter(logItem -> logItem.matches(httpRequestMatcher)).filter(logEntryPredicate).map(logEntryMapper));
        }));
    }

    public Future<String> verify(Verification verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(Verification verification, Consumer<String> resultConsumer) {
        String logCorrelationId = UUIDService.getUUID();
        if (verification != null) {
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(verification.getHttpRequest()).setMessageFormat("verifying requests that match:{}").setArguments(verification));
            }
            this.retrieveRequests(verification.getHttpRequest().withLogCorrelationId(logCorrelationId), httpRequests -> {
                try {
                    if (!verification.getTimes().matches(httpRequests.size())) {
                        this.retrieveRequests(null, allRequests -> {
                            String serializedRequestToBeVerified = this.requestDefinitionSerializer.serialize(true, verification.getHttpRequest());
                            String serializedAllRequestInLog = allRequests.size() == 1 ? this.requestDefinitionSerializer.serialize(true, (RequestDefinition)allRequests.get(0)) : this.requestDefinitionSerializer.serialize(true, (List<? extends RequestDefinition>)allRequests);
                            String failureMessage = "Request not found " + verification.getTimes() + ", expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                            Object[] arguments = new Object[]{verification.getHttpRequest(), allRequests.size() == 1 ? allRequests.get(0) : allRequests};
                            if (MockServerLogger.isEnabled(Level.INFO)) {
                                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION_FAILED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(verification.getHttpRequest()).setMessageFormat("request not found " + verification.getTimes() + ", expected:{}but was:{}").setArguments(arguments));
                            }
                            resultConsumer.accept(failureMessage);
                        });
                    } else {
                        if (MockServerLogger.isEnabled(Level.INFO)) {
                            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION_PASSED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(verification.getHttpRequest()).setMessageFormat("request:{}found " + verification.getTimes()).setArguments(verification.getHttpRequest()));
                        }
                        resultConsumer.accept("");
                    }
                }
                catch (Throwable throwable) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setCorrelationId(logCorrelationId).setMessageFormat("exception:{} while processing verification:{}").setArguments(throwable.getMessage(), verification).setThrowable(throwable));
                    resultConsumer.accept("exception while processing verification" + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? " " + throwable.getMessage() : ""));
                }
            });
        } else {
            resultConsumer.accept("");
        }
    }

    public Future<String> verify(VerificationSequence verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(VerificationSequence verificationSequence, Consumer<String> resultConsumer) {
        String logCorrelationId = UUIDService.getUUID();
        this.retrieveRequests(null, allRequests -> {
            try {
                if (verificationSequence != null) {
                    if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequests(verificationSequence.getHttpRequests().toArray(new RequestDefinition[0])).setMessageFormat("verifying sequence that match:{}").setArguments(verificationSequence));
                    }
                    String failureMessage = "";
                    int requestLogCounter = 0;
                    for (RequestDefinition verificationHttpRequest : verificationSequence.getHttpRequests()) {
                        if (verificationHttpRequest == null) continue;
                        verificationHttpRequest.withLogCorrelationId(logCorrelationId);
                        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                        boolean foundRequest = false;
                        while (!foundRequest && requestLogCounter < allRequests.size()) {
                            if (httpRequestMatcher.matches(((RequestDefinition)allRequests.get(requestLogCounter)).cloneWithLogCorrelationId())) {
                                foundRequest = true;
                            }
                            ++requestLogCounter;
                        }
                        if (foundRequest) continue;
                        String serializedRequestToBeVerified = this.requestDefinitionSerializer.serialize(true, verificationSequence.getHttpRequests());
                        String serializedAllRequestInLog = allRequests.size() == 1 ? this.requestDefinitionSerializer.serialize(true, (RequestDefinition)allRequests.get(0)) : this.requestDefinitionSerializer.serialize(true, (List<? extends RequestDefinition>)allRequests);
                        failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                        Object[] arguments = new Object[]{verificationSequence.getHttpRequests(), allRequests.size() == 1 ? allRequests.get(0) : allRequests};
                        if (!MockServerLogger.isEnabled(Level.INFO)) break;
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION_FAILED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequests(verificationSequence.getHttpRequests().toArray(new RequestDefinition[0])).setMessageFormat("request sequence not found, expected:{}but was:{}").setArguments(arguments));
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)failureMessage) && MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION_PASSED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("request sequence found:{}").setArguments(verificationSequence.getHttpRequests()));
                    }
                    resultConsumer.accept(failureMessage);
                } else {
                    resultConsumer.accept("");
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setCorrelationId(logCorrelationId).setMessageFormat("exception:{} while processing verification sequence:{}").setArguments(throwable.getMessage(), verificationSequence).setThrowable(throwable));
                resultConsumer.accept("exception while processing verification sequence" + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? " " + throwable.getMessage() : ""));
            }
        });
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

