/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mockserver.codec.ExpandedParameterDecoder;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.JsonSchemaMatcher;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterStyle;
import org.mockserver.model.Parameters;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JsonSchemaBodyDecoder {
    private static final String APPLICATION_XML = "application/xml";
    private static final String TEXT_XML = "text/xml";
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private final MockServerLogger mockServerLogger;
    private final Expectation expectation;
    private final HttpRequest httpRequest;
    private final ExpandedParameterDecoder formParameterParser;

    public JsonSchemaBodyDecoder(MockServerLogger mockServerLogger, Expectation expectation, HttpRequest httpRequest) {
        this.mockServerLogger = mockServerLogger;
        this.expectation = expectation;
        this.httpRequest = httpRequest;
        this.formParameterParser = new ExpandedParameterDecoder(mockServerLogger);
    }

    public String convertToJson(HttpRequest request, BodyMatcher<?> bodyMatcher) {
        String bodyAsJson = request.getBodyAsString();
        String contentType = request.getFirstHeader(Attributes.Name.CONTENT_TYPE.toString());
        if (contentType.contains(APPLICATION_XML) || contentType.contains(TEXT_XML)) {
            try {
                HashMap errors = new HashMap();
                Document document = new StringToXmlDocumentParser().buildDocument(request.getBodyAsString(), (matchedInException, throwable, level) -> errors.put(level, throwable.getMessage()));
                if (errors.containsKey((Object)StringToXmlDocumentParser.ErrorLevel.FATAL_ERROR)) {
                    throw new IllegalArgumentException(StringFormatter.formatLogMessage("failed to convert:{}to json for json schema matcher:{}", request.getBodyAsString(), bodyMatcher, Joiner.on((String)"\n").join(errors.values())));
                }
                for (Map.Entry errorEntry : errors.entrySet()) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to convert:{}to json for json schema matcher:{}").setArguments(request.getBodyAsString(), bodyMatcher, StringToXmlDocumentParser.ErrorLevel.prettyPrint((StringToXmlDocumentParser.ErrorLevel)((Object)errorEntry.getKey())) + ": " + (String)errorEntry.getValue()));
                }
                Object objectMap = this.xmlToMap(document.getFirstChild());
                bodyAsJson = ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(objectMap);
            }
            catch (Throwable throwable2) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setHttpRequest(request).setExpectation(this.expectation).setMessageFormat("exception parsing xml body for{}while matching against request{}").setArguments(request, this.httpRequest));
            }
        } else if (contentType.contains(APPLICATION_X_WWW_FORM_URLENCODED)) {
            ObjectNode objectNode = new ObjectNode(JsonNodeFactory.instance);
            Parameters parameters = this.formParameterParser.retrieveFormParameters(request.getBodyAsString(), false);
            if (bodyMatcher instanceof JsonSchemaMatcher) {
                this.splitParameters(((JsonSchemaMatcher)bodyMatcher).getParameterStyle(), parameters);
            }
            parameters.getEntries().forEach(parameter -> objectNode.set(NottableString.serialiseNottableString(parameter.getName()), JsonSchemaBodyDecoder.toJsonObject(NottableString.serialiseNottableStrings(parameter.getValues()))));
            bodyAsJson = objectNode.toPrettyString();
        }
        return bodyAsJson;
    }

    private void splitParameters(Map<String, ParameterStyle> parameterStyles, Parameters bodyParameters) {
        if (parameterStyles != null && bodyParameters != null) {
            for (Map.Entry<String, ParameterStyle> parameterStyleEntry : parameterStyles.entrySet()) {
                for (Parameter bodyParameterEntry : bodyParameters.getEntries()) {
                    if (!parameterStyleEntry.getKey().equals(bodyParameterEntry.getName().getValue())) continue;
                    bodyParameterEntry.replaceValues(new ExpandedParameterDecoder(this.mockServerLogger).splitOnDelimiter(parameterStyleEntry.getValue(), parameterStyleEntry.getKey(), bodyParameterEntry.getValues()));
                    bodyParameters.replaceEntry(bodyParameterEntry);
                }
            }
        }
    }

    private Object xmlToMap(Node node) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        NodeList childNodes = node.getChildNodes();
        JsonNode content = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (item.getChildNodes().getLength() > 0) {
                if (objectMap.containsKey(item.getNodeName())) {
                    Object object = objectMap.get(item.getNodeName());
                    if (object instanceof List) {
                        ((List)object).add(this.xmlToMap(item));
                        continue;
                    }
                    if (object == null) continue;
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(object);
                    list.add(this.xmlToMap(item));
                    objectMap.put(item.getNodeName(), list);
                    continue;
                }
                objectMap.put(item.getNodeName(), this.xmlToMap(item));
                continue;
            }
            if (item.getNodeType() != 3) continue;
            content = JsonSchemaBodyDecoder.toJsonObject(item.getTextContent().trim());
        }
        return objectMap.size() > 0 ? objectMap : content;
    }

    private static JsonNode toJsonObject(Collection<String> values) {
        if (values.size() == 0) {
            return NullNode.getInstance();
        }
        if (values.size() == 1) {
            return JsonSchemaBodyDecoder.toJsonObject(values.iterator().next());
        }
        return new ArrayNode(JsonNodeFactory.instance, values.stream().map(JsonSchemaBodyDecoder::toJsonObject).collect(Collectors.toList()));
    }

    private static JsonNode toJsonObject(@Nullable String value) {
        if (value == null || value.equalsIgnoreCase("null")) {
            return NullNode.getInstance();
        }
        String trimmed = value.trim();
        if (trimmed.equalsIgnoreCase("false")) {
            return BooleanNode.getFalse();
        }
        if (trimmed.equalsIgnoreCase("true")) {
            return BooleanNode.getTrue();
        }
        try {
            return new LongNode(Long.parseLong(trimmed));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new DoubleNode(Double.parseDouble(trimmed));
            }
            catch (NumberFormatException numberFormatException2) {
                return new TextNode(trimmed);
            }
        }
    }
}

