/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JacksonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.serialization.ObjectMapperFactory;

public class JsonArraySerializer {
    private static final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public List<String> returnJSONObjects(String jsonArray) {
        ArrayList<String> arrayItems = new ArrayList<String>();
        try {
            JsonNode jsonNode = objectMapper.readTree(jsonArray);
            if (jsonNode instanceof ArrayNode) {
                for (JsonNode arrayElement : jsonNode) {
                    arrayItems.add(JacksonUtils.prettyPrint((JsonNode)arrayElement));
                }
            } else {
                arrayItems.add(JacksonUtils.prettyPrint((JsonNode)jsonNode));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return arrayItems;
    }
}

