/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.scheduler;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.mockserver.client.SocketCommunicationException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.action.http.HttpForwardActionResult;
import org.mockserver.model.BinaryMessage;
import org.mockserver.model.Delay;
import org.mockserver.model.HttpResponse;
import org.slf4j.event.Level;

public class Scheduler {
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(ConfigurationProperties.actionHandlerThreadCount(), new SchedulerThreadFactory("Scheduler"), new ThreadPoolExecutor.CallerRunsPolicy());
    private final boolean synchronous;
    private final MockServerLogger mockServerLogger;

    public Scheduler(MockServerLogger mockServerLogger) {
        this(mockServerLogger, false);
    }

    @VisibleForTesting
    public Scheduler(MockServerLogger mockServerLogger, boolean synchronous) {
        this.mockServerLogger = mockServerLogger;
        this.synchronous = synchronous;
    }

    public synchronized void shutdown() {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void run(Runnable command, Integer port) {
        block2: {
            HttpState.setPort(port);
            try {
                command.run();
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled(Level.INFO)) break block2;
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.INFO).setMessageFormat(throwable.getMessage()).setThrowable(throwable));
            }
        }
    }

    public void schedule(Runnable command, boolean synchronous, Delay ... delays) {
        Delay delay = this.addDelays(delays);
        Integer port = HttpState.getPort();
        if (this.synchronous || synchronous) {
            if (delay != null) {
                delay.applyDelay();
            }
            this.run(command, port);
        } else if (delay != null) {
            this.scheduler.schedule(() -> this.run(command, port), delay.getValue(), delay.getTimeUnit());
        } else {
            this.run(command, port);
        }
    }

    private Delay addDelays(Delay ... delays) {
        if (delays == null || delays.length == 0) {
            return null;
        }
        if (delays.length == 1) {
            return delays[0];
        }
        if (delays.length == 2 && delays[0] == delays[1]) {
            return delays[0];
        }
        long timeInMilliseconds = 0L;
        for (Delay delay : delays) {
            if (delay == null) continue;
            timeInMilliseconds += delay.getTimeUnit().toMillis(delay.getValue());
        }
        return new Delay(TimeUnit.MILLISECONDS, timeInMilliseconds);
    }

    public void submit(Runnable command) {
        this.submit(command, false);
    }

    public void submit(Runnable command, boolean synchronous) {
        Integer port = HttpState.getPort();
        if (this.synchronous || synchronous) {
            this.run(command, port);
        } else {
            this.scheduler.submit(() -> this.run(command, port));
        }
    }

    public void submit(HttpForwardActionResult future, Runnable command, boolean synchronous) {
        Integer port = HttpState.getPort();
        if (future != null) {
            if (this.synchronous || synchronous) {
                try {
                    future.getHttpResponse().get(ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    future.getHttpResponse().completeExceptionally(new SocketCommunicationException("Response was not received after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause()));
                }
                catch (InterruptedException | ExecutionException ex) {
                    future.getHttpResponse().completeExceptionally(ex);
                }
                this.run(command, port);
            } else {
                future.getHttpResponse().whenCompleteAsync((httpResponse, throwable) -> {
                    if (throwable != null && MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.INFO).setMessageFormat(throwable.getMessage()).setThrowable((Throwable)throwable));
                    }
                    this.run(command, port);
                }, (Executor)this.scheduler);
            }
        }
    }

    public void submit(CompletableFuture<BinaryMessage> future, Runnable command, boolean synchronous) {
        Integer port = HttpState.getPort();
        if (future != null) {
            if (this.synchronous || synchronous) {
                try {
                    future.get(ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    future.completeExceptionally(new SocketCommunicationException("Response was not received after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause()));
                }
                catch (InterruptedException | ExecutionException ex) {
                    future.completeExceptionally(ex);
                }
                this.run(command, port);
            } else {
                future.whenCompleteAsync((httpResponse, throwable) -> command.run(), (Executor)this.scheduler);
            }
        }
    }

    public void submit(HttpForwardActionResult future, BiConsumer<HttpResponse, Throwable> consumer, boolean synchronous) {
        block8: {
            if (future != null) {
                if (this.synchronous || synchronous) {
                    HttpResponse httpResponse = null;
                    Exception exception = null;
                    try {
                        httpResponse = future.getHttpResponse().get(ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        exception = new SocketCommunicationException("Response was not received after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause());
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        exception = ex;
                    }
                    try {
                        consumer.accept(httpResponse, exception);
                    }
                    catch (Throwable throwable) {
                        if (MockServerLogger.isEnabled(Level.INFO)) {
                            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.INFO).setMessageFormat(throwable.getMessage()).setThrowable(throwable));
                        }
                        break block8;
                    }
                }
                future.getHttpResponse().whenCompleteAsync((BiConsumer)consumer, (Executor)this.scheduler);
            }
        }
    }

    public static class SchedulerThreadFactory
    implements ThreadFactory {
        private final String name;
        private final boolean daemon;
        private static int threadInitNumber;

        public SchedulerThreadFactory(String name) {
            this.name = name;
            this.daemon = true;
        }

        public SchedulerThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "MockServer-" + this.name + threadInitNumber++);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }
}

