/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.placeholder.PlaceholderDifferenceEvaluator;

public class XmlStringMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "diffBuilder"};
    private final MockServerLogger mockServerLogger;
    private DiffBuilder diffBuilder;
    private NottableString matcher = NottableString.string("THIS SHOULD NEVER MATCH");

    XmlStringMatcher(MockServerLogger mockServerLogger, String matcher) {
        this(mockServerLogger, NottableString.string(matcher));
    }

    XmlStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        try {
            this.matcher = matcher;
            this.diffBuilder = DiffBuilder.compare((Object)Input.fromString((String)this.matcher.getValue())).ignoreComments().ignoreWhitespace().normalizeWhitespace().checkForSimilar();
        }
        catch (Exception e) {
            mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("error while creating xml string matcher for [" + matcher + "]" + e.getMessage()).setThrowable(e));
        }
    }

    public boolean matches(String matched) {
        return this.matches((MatchDifference)null, matched);
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result;
        block4: {
            result = false;
            if (this.diffBuilder != null) {
                try {
                    Diff diff = this.diffBuilder.withTest((Object)Input.fromString((String)matched)).withDifferenceEvaluator((DifferenceEvaluator)new PlaceholderDifferenceEvaluator()).build();
                    boolean bl = result = !diff.hasDifferences();
                    if (!result && context != null) {
                        context.addDifference(this.mockServerLogger, "xml match failed expected:{}found:{}failed because:{}", this.matcher, matched, diff.toString());
                    }
                }
                catch (Throwable throwable) {
                    if (context == null) break block4;
                    context.addDifference(this.mockServerLogger, throwable, "xml match failed expected:{}found:{}failed because:{}", this.matcher, matched, throwable.getMessage());
                }
            }
        }
        return this.matcher.isNot() == (this.not == result);
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((CharSequence)this.matcher.getValue());
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

