/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.ui.MockServerMatcherListener;

public class MockServerMatcherNotifier
extends ObjectWithReflectiveEqualsHashCodeToString {
    private boolean listenerAdded = false;
    private final List<MockServerMatcherListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Scheduler scheduler;

    public MockServerMatcherNotifier(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void notifyListeners(RequestMatchers notifier, Cause cause) {
        if (this.listenerAdded && !this.listeners.isEmpty()) {
            for (MockServerMatcherListener listener : this.listeners.toArray(new MockServerMatcherListener[0])) {
                this.scheduler.submit(() -> listener.updated(notifier, cause));
            }
        }
    }

    public void registerListener(MockServerMatcherListener listener) {
        this.listeners.add(listener);
        this.listenerAdded = true;
    }

    public void unregisterListener(MockServerMatcherListener listener) {
        this.listeners.remove(listener);
    }

    public static enum Cause {
        FILE_WATCHER,
        INITIALISER,
        API;

    }
}

