/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.JsonBody;
import org.mockserver.model.LogEventBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.StringBody;
import org.mockserver.model.XmlBody;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.LogEventBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;

public abstract class BodyWithContentTypeDTO
extends BodyDTO {
    protected final String contentType;

    public BodyWithContentTypeDTO(Body.Type type, Boolean not, Body<?> body) {
        super(type, not);
        this.contentType = body.getContentType();
        this.withOptional(body.getOptional());
    }

    public static BodyWithContentTypeDTO createWithContentTypeDTO(BodyWithContentType<?> body) {
        BodyWithContentTypeDTO result = null;
        if (body instanceof BinaryBody) {
            BinaryBody binaryBody = (BinaryBody)body;
            result = new BinaryBodyDTO(binaryBody, binaryBody.getNot());
        } else if (body instanceof JsonBody) {
            JsonBody jsonBody = (JsonBody)body;
            result = new JsonBodyDTO(jsonBody, jsonBody.getNot());
        } else if (body instanceof StringBody) {
            StringBody stringBody = (StringBody)body;
            result = new StringBodyDTO(stringBody, stringBody.getNot());
        } else if (body instanceof XmlBody) {
            XmlBody xmlBody = (XmlBody)body;
            result = new XmlBodyDTO(xmlBody, xmlBody.getNot());
        } else if (body instanceof LogEventBody) {
            LogEventBody logEventBody = (LogEventBody)body;
            result = new LogEventBodyDTO(logEventBody);
        }
        if (result != null) {
            result.withOptional(body.getOptional());
        }
        return result;
    }

    public String getContentType() {
        return this.contentType;
    }

    @JsonIgnore
    MediaType getMediaType() {
        return this.contentType != null ? MediaType.parse(this.contentType) : null;
    }

    @Override
    public abstract BodyWithContentType<?> buildObject();
}

