/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.validator.jsonschema.JsonSchemaHttpResponseValidator;
import org.slf4j.event.Level;

public class HttpResponseSerializer
implements Serializer<HttpResponse> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaHttpResponseValidator httpResponseValidator;

    public HttpResponseSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    private JsonSchemaHttpResponseValidator getValidator() {
        if (this.httpResponseValidator == null) {
            this.httpResponseValidator = JsonSchemaHttpResponseValidator.jsonSchemaHttpResponseValidator(this.mockServerLogger);
        }
        return this.httpResponseValidator;
    }

    @Override
    public String serialize(HttpResponse httpResponse) {
        try {
            return this.objectWriter.writeValueAsString((Object)new HttpResponseDTO(httpResponse));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing httpResponse to JSON with value " + httpResponse).setThrowable(e));
            throw new RuntimeException("Exception while serializing httpResponse to JSON with value " + httpResponse, e);
        }
    }

    @Override
    public String serialize(List<HttpResponse> httpResponses) {
        return this.serialize(httpResponses.toArray(new HttpResponse[0]));
    }

    @Override
    public String serialize(HttpResponse ... httpResponses) {
        try {
            if (httpResponses != null && httpResponses.length > 0) {
                HttpResponseDTO[] httpResponseDTOs = new HttpResponseDTO[httpResponses.length];
                for (int i = 0; i < httpResponses.length; ++i) {
                    httpResponseDTOs[i] = new HttpResponseDTO(httpResponses[i]);
                }
                return this.objectWriter.writeValueAsString((Object)httpResponseDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing HttpResponse to JSON with value " + Arrays.asList(httpResponses)).setThrowable(e));
            throw new RuntimeException("Exception while serializing HttpResponse to JSON with value " + Arrays.asList(httpResponses), e);
        }
    }

    @Override
    public HttpResponse deserialize(String jsonHttpResponse) {
        String validationErrors;
        if (StringUtils.isBlank((CharSequence)jsonHttpResponse)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response is required but value was \"" + jsonHttpResponse + "\"" + Character.NEW_LINE + Character.NEW_LINE + "See: https://app.swaggerhub.com/apis/jamesdbloom/mock-server-openapi/5.11.x for OpenAPI Specification");
        }
        if (jsonHttpResponse.contains("\"httpResponse\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpResponse);
                if (jsonNode.has("httpResponse")) {
                    jsonHttpResponse = jsonNode.get("httpResponse").toString();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for HttpResponse" + throwable.getMessage()).setArguments(jsonHttpResponse).setThrowable(throwable));
                throw new RuntimeException("exception while parsing [" + jsonHttpResponse + "] for HttpResponse", throwable);
            }
        }
        if ((validationErrors = this.getValidator().isValid(jsonHttpResponse)).isEmpty()) {
            HttpResponse httpResponse = null;
            try {
                HttpResponseDTO httpResponseDTO = (HttpResponseDTO)this.objectMapper.readValue(jsonHttpResponse, HttpResponseDTO.class);
                if (httpResponseDTO != null) {
                    httpResponse = httpResponseDTO.buildObject();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for HttpResponse " + throwable.getMessage()).setArguments(jsonHttpResponse).setThrowable(throwable));
                throw new RuntimeException("exception while parsing [" + jsonHttpResponse + "] for HttpResponse", throwable);
            }
            return httpResponse;
        }
        throw new IllegalArgumentException(StringUtils.removeEndIgnoreCase((String)StringFormatter.formatLogMessage("incorrect response json format for:{}schema validation errors:{}", jsonHttpResponse, validationErrors), (String)"\n"));
    }

    @Override
    public Class<HttpResponse> supportsType() {
        return HttpResponse.class;
    }

    public HttpResponse[] deserializeArray(String jsonHttpResponses) {
        ArrayList<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
        if (StringUtils.isBlank((CharSequence)jsonHttpResponses)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response or response array is required but value was \"" + jsonHttpResponses + "\"");
        }
        List<String> jsonResponseList = this.jsonArraySerializer.returnJSONObjects(jsonHttpResponses);
        if (jsonResponseList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response or array of response is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonExpecation : jsonResponseList) {
            try {
                httpResponses.add(this.deserialize(jsonExpecation));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on((String)("," + Character.NEW_LINE)).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpResponses.toArray(new HttpResponse[0]);
    }
}

