/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.validator.jsonschema.JsonSchemaHttpRequestValidator;
import org.slf4j.event.Level;

public class HttpRequestSerializer
implements Serializer<HttpRequest> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaHttpRequestValidator httpRequestValidator;

    public HttpRequestSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    private JsonSchemaHttpRequestValidator getValidator() {
        if (this.httpRequestValidator == null) {
            this.httpRequestValidator = JsonSchemaHttpRequestValidator.jsonSchemaHttpRequestValidator(this.mockServerLogger);
        }
        return this.httpRequestValidator;
    }

    @Override
    public String serialize(HttpRequest httpRequest) {
        return this.serialize(false, httpRequest);
    }

    public String serialize(boolean prettyPrint, HttpRequest httpRequest) {
        try {
            if (prettyPrint) {
                return this.objectWriter.writeValueAsString((Object)new HttpRequestTemplateObject(httpRequest));
            }
            return this.objectWriter.writeValueAsString((Object)new HttpRequestDTO(httpRequest));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing HttpRequest to JSON with value " + httpRequest).setThrowable(e));
            throw new RuntimeException("Exception while serializing HttpRequest to JSON with value " + httpRequest, e);
        }
    }

    @Override
    public String serialize(List<HttpRequest> httpRequests) {
        return this.serialize(false, httpRequests);
    }

    public String serialize(boolean prettyPrint, List<HttpRequest> httpRequests) {
        return this.serialize(prettyPrint, httpRequests.toArray(new HttpRequest[0]));
    }

    @Override
    public String serialize(HttpRequest ... httpRequests) {
        return this.serialize(false, httpRequests);
    }

    public String serialize(boolean prettyPrint, HttpRequest ... httpRequests) {
        try {
            if (httpRequests != null && httpRequests.length > 0) {
                if (prettyPrint) {
                    HttpRequestTemplateObject[] httpRequestTemplateObjects = new HttpRequestTemplateObject[httpRequests.length];
                    for (int i = 0; i < httpRequests.length; ++i) {
                        httpRequestTemplateObjects[i] = new HttpRequestTemplateObject(httpRequests[i]);
                    }
                    return this.objectWriter.writeValueAsString((Object)httpRequestTemplateObjects);
                }
                HttpRequestDTO[] httpRequestDTOs = new HttpRequestDTO[httpRequests.length];
                for (int i = 0; i < httpRequests.length; ++i) {
                    httpRequestDTOs[i] = new HttpRequestDTO(httpRequests[i]);
                }
                return this.objectWriter.writeValueAsString((Object)httpRequestDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing HttpRequest to JSON with value " + Arrays.asList(httpRequests)).setThrowable(e));
            throw new RuntimeException("Exception while serializing HttpRequest to JSON with value " + Arrays.asList(httpRequests), e);
        }
    }

    @Override
    public HttpRequest deserialize(String jsonHttpRequest) {
        String validationErrors;
        if (StringUtils.isBlank((CharSequence)jsonHttpRequest)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request is required but value was \"" + jsonHttpRequest + "\"" + Character.NEW_LINE + Character.NEW_LINE + "See: https://app.swaggerhub.com/apis/jamesdbloom/mock-server-openapi/5.11.x for OpenAPI Specification");
        }
        if (jsonHttpRequest.contains("\"httpRequest\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpRequest);
                if (jsonNode.has("httpRequest")) {
                    jsonHttpRequest = jsonNode.get("httpRequest").toString();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for HttpRequest " + throwable.getMessage()).setArguments(jsonHttpRequest).setThrowable(throwable));
                throw new RuntimeException("exception while parsing [" + jsonHttpRequest + "] for HttpRequest", throwable);
            }
        }
        if ((validationErrors = this.getValidator().isValid(jsonHttpRequest)).isEmpty()) {
            HttpRequest httpRequest = null;
            try {
                HttpRequestDTO httpRequestDTO = (HttpRequestDTO)this.objectMapper.readValue(jsonHttpRequest, HttpRequestDTO.class);
                if (httpRequestDTO != null) {
                    httpRequest = httpRequestDTO.buildObject();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for HttpRequest" + throwable.getMessage()).setArguments(jsonHttpRequest).setThrowable(throwable));
                throw new RuntimeException("exception while parsing [" + jsonHttpRequest + "] for HttpRequest", throwable);
            }
            return httpRequest;
        }
        throw new IllegalArgumentException(StringUtils.removeEndIgnoreCase((String)StringFormatter.formatLogMessage("incorrect request json format for:{}schema validation errors:{}", jsonHttpRequest, validationErrors), (String)"\n"));
    }

    @Override
    public Class<HttpRequest> supportsType() {
        return HttpRequest.class;
    }

    public HttpRequest[] deserializeArray(String jsonHttpRequests) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        if (StringUtils.isBlank((CharSequence)jsonHttpRequests)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or request array is required but value was \"" + jsonHttpRequests + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.returnJSONObjects(jsonHttpRequests);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                httpRequests.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on((String)("," + Character.NEW_LINE)).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpRequests.toArray(new HttpRequest[0]);
    }
}

