/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.ExpectationDTO;
import org.mockserver.validator.jsonschema.JsonSchemaExpectationValidator;
import org.slf4j.event.Level;

public class ExpectationSerializer
implements Serializer<Expectation> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaExpectationValidator expectationValidator;
    private static boolean printedECMA262Warning = false;

    public ExpectationSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    private JsonSchemaExpectationValidator getValidator() {
        if (this.expectationValidator == null) {
            if (!printedECMA262Warning) {
                if (!System.getProperty("java.version").contains("1.8") && !System.getProperty("java.version").contains("1.9")) {
                    try {
                        this.getClass().getClassLoader().loadClass("jdk.nashorn.api.scripting.NashornScriptEngineFactory");
                        System.err.println("Loading JavaScript to validate ECMA262 regular expression in JsonSchema because java.util.regex package in Java does not match ECMA262");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                printedECMA262Warning = true;
            }
            this.expectationValidator = JsonSchemaExpectationValidator.jsonSchemaExpectationValidator(this.mockServerLogger);
        }
        return this.expectationValidator;
    }

    @Override
    public String serialize(Expectation expectation) {
        if (expectation != null) {
            try {
                return this.objectWriter.writeValueAsString((Object)new ExpectationDTO(expectation));
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing expectation to JSON with value " + expectation).setThrowable(e));
                throw new RuntimeException("Exception while serializing expectation to JSON with value " + expectation, e);
            }
        }
        return "";
    }

    @Override
    public String serialize(List<Expectation> expectations) {
        return this.serialize(expectations.toArray(new Expectation[0]));
    }

    @Override
    public String serialize(Expectation ... expectations) {
        try {
            if (expectations != null && expectations.length > 0) {
                ExpectationDTO[] expectationDTOs = new ExpectationDTO[expectations.length];
                for (int i = 0; i < expectations.length; ++i) {
                    expectationDTOs[i] = new ExpectationDTO(expectations[i]);
                }
                return this.objectWriter.writeValueAsString((Object)expectationDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing expectation to JSON with value " + Arrays.asList(expectations)).setThrowable(e));
            throw new RuntimeException("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations), e);
        }
    }

    @Override
    public Expectation deserialize(String jsonExpectation) {
        if (StringUtils.isBlank((CharSequence)jsonExpectation)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation is required but value was \"" + jsonExpectation + "\"" + Character.NEW_LINE + Character.NEW_LINE + "See: https://app.swaggerhub.com/apis/jamesdbloom/mock-server-openapi/5.11.x for OpenAPI Specification");
        }
        String validationErrors = this.getValidator().isValid(jsonExpectation);
        if (validationErrors.isEmpty()) {
            Expectation expectation = null;
            try {
                ExpectationDTO expectationDTO = (ExpectationDTO)this.objectMapper.readValue(jsonExpectation, ExpectationDTO.class);
                if (expectationDTO != null) {
                    expectation = expectationDTO.buildObject();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for Expectation " + throwable.getMessage()).setArguments(jsonExpectation).setThrowable(throwable));
                throw new RuntimeException("exception while parsing [" + jsonExpectation + "] for Expectation", throwable);
            }
            return expectation;
        }
        throw new IllegalArgumentException(StringUtils.removeEndIgnoreCase((String)StringFormatter.formatLogMessage("incorrect expectation json format for:{}schema validation errors:{}", jsonExpectation, validationErrors), (String)"\n"));
    }

    @Override
    public Class<Expectation> supportsType() {
        return Expectation.class;
    }

    public Expectation[] deserializeArray(String jsonExpectations, boolean allowEmpty) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        if (StringUtils.isBlank((CharSequence)jsonExpectations)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation or expectation array is required but value was \"" + jsonExpectations + "\"");
        }
        List<String> jsonExpectationList = this.jsonArraySerializer.returnJSONObjects(jsonExpectations);
        if (!jsonExpectationList.isEmpty()) {
            ArrayList<String> validationErrorsList = new ArrayList<String>();
            for (int i = 0; i < jsonExpectationList.size(); ++i) {
                String jsonExpectation = jsonExpectationList.get(i);
                if (jsonExpectationList.size() > 100) {
                    if (MockServerLogger.isEnabled(Level.DEBUG)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("processing JSON expectation " + (i + 1) + " of " + jsonExpectationList.size() + ":{}").setArguments(jsonExpectation));
                    } else if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("processing JSON expectation " + (i + 1) + " of " + jsonExpectationList.size()));
                    }
                }
                try {
                    expectations.add(this.deserialize(jsonExpectation));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    validationErrorsList.add(iae.getMessage());
                }
            }
            if (!validationErrorsList.isEmpty()) {
                if (validationErrorsList.size() > 1) {
                    throw new IllegalArgumentException(("[" + Character.NEW_LINE + Joiner.on((String)("," + Character.NEW_LINE + Character.NEW_LINE)).join(validationErrorsList)).replaceAll(Character.NEW_LINE, Character.NEW_LINE + "  ") + Character.NEW_LINE + "]");
                }
                throw new IllegalArgumentException((String)validationErrorsList.get(0));
            }
        } else if (!allowEmpty) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation or array of expectations is required");
        }
        return expectations.toArray(new Expectation[0]);
    }
}

