/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi.examples;

import io.swagger.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.media.XML;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.mockserver.openapi.examples.models.ArrayExample;
import org.mockserver.openapi.examples.models.BooleanExample;
import org.mockserver.openapi.examples.models.DecimalExample;
import org.mockserver.openapi.examples.models.DoubleExample;
import org.mockserver.openapi.examples.models.Example;
import org.mockserver.openapi.examples.models.FloatExample;
import org.mockserver.openapi.examples.models.IntegerExample;
import org.mockserver.openapi.examples.models.LongExample;
import org.mockserver.openapi.examples.models.ObjectExample;
import org.mockserver.openapi.examples.models.StringExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleBuilder.class);
    public static final String SAMPLE_EMAIL_PROPERTY_VALUE = "some_email@mockserver.com";
    public static final String SAMPLE_UUID_PROPERTY_VALUE = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
    public static final String SAMPLE_STRING_PROPERTY_VALUE = "some_string_value";
    public static final int SAMPLE_INT_PROPERTY_VALUE = 0;
    public static final int SAMPLE_LONG_PROPERTY_VALUE = 0;
    public static final int SAMPLE_BASE_INTEGER_PROPERTY_VALUE = 0;
    public static final float SAMPLE_FLOAT_PROPERTY_VALUE = 1.1f;
    public static final double SAMPLE_DOUBLE_PROPERTY_VALUE = (double)1.1f;
    public static final boolean SAMPLE_BOOLEAN_PROPERTY_VALUE = true;
    public static final String SAMPLE_DATE_PROPERTY_VALUE = "2018-11-13";
    public static final String SAMPLE_TIME_PROPERTY_VALUE = "20:20:39+00:00";
    public static final String SAMPLE_DATETIME_PROPERTY_VALUE = "2018-11-13T20:20:39+00:00";
    public static final double SAMPLE_DECIMAL_PROPERTY_VALUE = 1.5;

    public static Example fromSchema(Schema<?> property, Map<String, Schema> definitions) {
        return ExampleBuilder.fromProperty(null, property, definitions, new HashMap<String, Example>());
    }

    public static Example fromProperty(String name, Schema<?> property, Map<String, Schema> definitions, Map<String, Example> processedModels) {
        Example innerExample;
        Schema inner;
        List enums;
        Object defaultValue;
        if (property == null) {
            return null;
        }
        String namespace = null;
        String prefix = null;
        Boolean attribute = false;
        boolean wrapped = false;
        if (property.getXml() != null) {
            XML xml = property.getXml();
            name = xml.getName();
            namespace = xml.getNamespace();
            prefix = xml.getPrefix();
            attribute = xml.getAttribute();
            wrapped = xml.getWrapped() != null ? xml.getWrapped() : false;
        }
        Object output = null;
        Object example = property.getExample();
        if (property.get$ref() != null) {
            Schema model;
            String ref = property.get$ref();
            if (processedModels.containsKey(ref = ref.substring(ref.lastIndexOf("/") + 1))) {
                return ExampleBuilder.alreadyProcessedRefExample(ref, definitions, processedModels);
            }
            processedModels.put(ref, null);
            if (definitions != null && (model = definitions.get(ref)) != null) {
                output = ExampleBuilder.fromProperty(ref, model, definitions, processedModels);
                processedModels.put(ref, (Example)output);
                return output;
            }
        } else if (property instanceof EmailSchema) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = (String)((EmailSchema)property).getDefault();
                if (defaultValue == null && (enums = ((EmailSchema)property).getEnum()) != null && !enums.isEmpty()) {
                    defaultValue = (String)enums.get(0);
                }
                output = new StringExample((String)(defaultValue == null ? SAMPLE_EMAIL_PROPERTY_VALUE : defaultValue));
            }
        } else if (property instanceof UUIDSchema) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = (UUID)((UUIDSchema)property).getDefault();
                if (defaultValue == null && (enums = ((UUIDSchema)property).getEnum()) != null && !enums.isEmpty()) {
                    defaultValue = (UUID)enums.get(0);
                }
                output = new StringExample(defaultValue == null ? SAMPLE_UUID_PROPERTY_VALUE : ((UUID)defaultValue).toString());
            }
        } else if (property instanceof StringSchema) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = (String)((StringSchema)property).getDefault();
                if (defaultValue == null && (enums = ((StringSchema)property).getEnum()) != null && !enums.isEmpty()) {
                    defaultValue = (String)enums.get(0);
                }
                output = new StringExample((String)(defaultValue == null ? SAMPLE_STRING_PROPERTY_VALUE : defaultValue));
            }
        } else if (property instanceof PasswordSchema) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = (String)((PasswordSchema)property).getDefault();
                if (defaultValue == null && (enums = ((PasswordSchema)property).getEnum()) != null && !enums.isEmpty()) {
                    defaultValue = (String)enums.get(0);
                }
                output = new StringExample((String)(defaultValue == null ? SAMPLE_STRING_PROPERTY_VALUE : defaultValue));
            }
        } else if (property instanceof IntegerSchema) {
            if (example != null) {
                try {
                    if (property.getFormat() != null) {
                        if (property.getFormat().equals("int32")) {
                            output = new IntegerExample(Integer.parseInt(example.toString()));
                        } else if (property.getFormat().equals("int64")) {
                            output = new LongExample(Long.parseLong(example.toString()));
                        }
                    } else {
                        output = new IntegerExample(Integer.parseInt(example.toString()));
                    }
                }
                catch (NumberFormatException defaultValue2) {
                    // empty catch block
                }
            }
            if (output == null) {
                defaultValue = (Number)((IntegerSchema)property).getDefault();
                if (defaultValue == null && (enums = ((IntegerSchema)property).getEnum()) != null && !enums.isEmpty()) {
                    defaultValue = (Number)enums.get(0);
                }
                if (property.getFormat() != null) {
                    if (property.getFormat().equals("int32")) {
                        output = new IntegerExample(defaultValue == null ? 0 : ((Number)defaultValue).intValue());
                    } else if (property.getFormat().equals("int64")) {
                        output = new LongExample(defaultValue == null ? 0L : ((Number)defaultValue).longValue());
                    }
                } else {
                    output = new IntegerExample(0);
                }
            }
        } else if (property instanceof NumberSchema) {
            if (example != null) {
                try {
                    if (property.getFormat() != null) {
                        if (property.getFormat().equals("double")) {
                            output = new DoubleExample(Double.parseDouble(example.toString()));
                        } else if (property.getFormat().equals("float")) {
                            output = new FloatExample(Float.parseFloat(example.toString()));
                        }
                    } else {
                        output = new DecimalExample(new BigDecimal(example.toString()));
                    }
                }
                catch (NumberFormatException defaultValue3) {
                    // empty catch block
                }
            }
            if (output == null) {
                defaultValue = (BigDecimal)((NumberSchema)property).getDefault();
                if (defaultValue == null && (enums = ((NumberSchema)property).getEnum()) != null && !enums.isEmpty()) {
                    defaultValue = (BigDecimal)enums.get(0);
                }
                if (property.getFormat() != null) {
                    if (property.getFormat().equals("double")) {
                        output = new DoubleExample(defaultValue == null ? (double)1.1f : ((BigDecimal)defaultValue).doubleValue());
                    }
                    if (property.getFormat().equals("float")) {
                        output = new FloatExample(defaultValue == null ? 1.1f : ((BigDecimal)defaultValue).floatValue());
                    }
                } else {
                    output = new DecimalExample(new BigDecimal(1.5));
                }
            }
        } else if (property instanceof BooleanSchema) {
            output = example != null ? new BooleanExample(Boolean.parseBoolean(example.toString())) : new BooleanExample((defaultValue = (Boolean)property.getDefault()) == null ? true : (Boolean)defaultValue);
        } else if (property instanceof DateSchema) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if (example != null) {
                String exampleAsString = format.format(example);
                output = new StringExample(exampleAsString);
            } else {
                enums = ((DateSchema)property).getEnum();
                output = enums != null && !enums.isEmpty() ? new StringExample(format.format((Date)enums.get(0))) : new StringExample(SAMPLE_DATE_PROPERTY_VALUE);
            }
        } else if (property instanceof DateTimeSchema) {
            if (example != null) {
                String exampleAsString = example.toString();
                output = new StringExample(exampleAsString);
            } else {
                List enums2 = ((DateTimeSchema)property).getEnum();
                output = enums2 != null && !enums2.isEmpty() ? new StringExample(((OffsetDateTime)enums2.get(0)).toString()) : new StringExample(SAMPLE_DATETIME_PROPERTY_VALUE);
            }
        } else if (property instanceof ObjectSchema) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(example.toString(), ObjectExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ObjectExample();
                }
            } else {
                ObjectExample outputExample = new ObjectExample();
                outputExample.setName(property.getName());
                ObjectSchema op = (ObjectSchema)property;
                if (op.getProperties() != null) {
                    for (String propertyname : op.getProperties().keySet()) {
                        inner = (Schema)op.getProperties().get(propertyname);
                        Example innerExample2 = ExampleBuilder.fromProperty(null, inner, definitions, processedModels);
                        outputExample.put(propertyname, innerExample2);
                    }
                    output = outputExample;
                }
            }
        } else if (property instanceof ArraySchema) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(example.toString(), ArrayExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ArrayExample();
                }
            } else {
                ArraySchema ap = (ArraySchema)property;
                Schema inner2 = ap.getItems();
                if (inner2 != null && (innerExample = ExampleBuilder.fromProperty(null, inner2, definitions, processedModels)) != null) {
                    ArrayExample an = new ArrayExample();
                    an.add(innerExample);
                    an.setName(property.getName());
                    output = an;
                }
            }
        } else if (property instanceof ComposedSchema) {
            Example innerExample3;
            List models;
            ComposedSchema composedSchema = (ComposedSchema)property;
            if (composedSchema.getAllOf() != null) {
                models = composedSchema.getAllOf();
                Iterator<Object> ex = new ObjectExample();
                ArrayList<Example> innerExamples = new ArrayList<Example>();
                if (models != null) {
                    for (Schema im : models) {
                        Example innerExample4 = ExampleBuilder.fromProperty(null, im, definitions, processedModels);
                        if (innerExample4 == null) continue;
                        innerExamples.add(innerExample4);
                    }
                }
                ExampleBuilder.mergeTo(ex, innerExamples);
                output = ex;
            }
            if (composedSchema.getAnyOf() != null && (models = composedSchema.getAnyOf()) != null) {
                for (Schema im : models) {
                    innerExample3 = ExampleBuilder.fromProperty(null, im, definitions, processedModels);
                    if (innerExample3 == null) continue;
                    output = innerExample3;
                    break;
                }
            }
            if (composedSchema.getOneOf() != null && (models = composedSchema.getOneOf()) != null) {
                for (Schema im : models) {
                    innerExample3 = ExampleBuilder.fromProperty(null, im, definitions, processedModels);
                    if (innerExample3 == null) continue;
                    output = innerExample3;
                    break;
                }
            }
        } else if (property.getProperties() != null) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(example.toString(), ObjectExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ObjectExample();
                }
            } else {
                ObjectExample ex = new ObjectExample();
                if (property.getProperties() != null) {
                    Map properties = property.getProperties();
                    for (String propertyKey : properties.keySet()) {
                        inner = (Schema)properties.get(propertyKey);
                        Example propExample = ExampleBuilder.fromProperty(null, inner, definitions, processedModels);
                        ex.put(propertyKey, propExample);
                    }
                }
                output = ex;
            }
        }
        if (property.getAdditionalProperties() instanceof Schema) {
            Schema inner3 = (Schema)property.getAdditionalProperties();
            if (inner3 != null) {
                for (int i = 1; i <= 3; ++i) {
                    innerExample = ExampleBuilder.fromProperty(null, inner3, definitions, processedModels);
                    if (innerExample == null) continue;
                    if (output == null) {
                        output = new ObjectExample();
                    }
                    ObjectExample on = null;
                    if (output instanceof ObjectExample) {
                        on = (ObjectExample)output;
                    }
                    String key = "additionalProp" + i;
                    if (innerExample.getName() == null) {
                        innerExample.setName(key);
                    }
                    if (on == null || on.keySet().contains(key)) continue;
                    on.put(key, innerExample);
                }
            }
        } else if (property.getAdditionalProperties() instanceof Boolean && output == null) {
            output = new ObjectExample();
        }
        if (output != null) {
            if (attribute != null) {
                output.setAttribute(attribute);
            }
            if (wrapped) {
                if (name != null) {
                    output.setWrappedName(name);
                }
            } else if (name != null) {
                output.setName(name);
            }
            output.setNamespace(namespace);
            output.setPrefix(prefix);
            output.setWrapped(wrapped);
        }
        return output;
    }

    public static Example alreadyProcessedRefExample(String name, Map<String, Schema> definitions, Map<String, Example> processedModels) {
        if (processedModels.get(name) != null) {
            return processedModels.get(name);
        }
        Schema model = definitions.get(name);
        if (model == null) {
            return null;
        }
        Example output = null;
        if (model.getType() != null) {
            if ("object".equals(model.getType())) {
                return new ObjectExample();
            }
            if ("string".equals(model.getType())) {
                return new StringExample("");
            }
            if ("integer".equals(model.getType())) {
                return new IntegerExample(0);
            }
            if ("long".equals(model.getType())) {
                return new LongExample(0L);
            }
            if ("float".equals(model.getType())) {
                return new FloatExample(0.0f);
            }
            if ("double".equals(model.getType())) {
                return new DoubleExample(0.0);
            }
        }
        return output;
    }

    public static void mergeTo(ObjectExample output, List<Example> examples) {
        for (Example ex : examples) {
            ObjectExample objectExample;
            Map<String, Example> values;
            if (!(ex instanceof ObjectExample) || (values = (objectExample = (ObjectExample)ex).getValues()) == null) continue;
            output.putAll(values);
        }
    }
}

