/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.Arrays;
import java.util.Collection;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.NottableOptionalString;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.NottableString;
import org.mockserver.model.ParameterStyle;

public class Parameter
extends KeyToMultiValue {
    public Parameter(String name, String ... value) {
        super(name, value);
    }

    public Parameter(NottableString name, NottableString ... value) {
        super(name, value);
    }

    public Parameter(String name, Collection<String> value) {
        super(name, value);
    }

    public Parameter(NottableString name, Collection<NottableString> value) {
        super(name, value);
    }

    public static Parameter param(String name, String ... value) {
        return new Parameter(name, value);
    }

    public static Parameter param(NottableString name, NottableString ... value) {
        return new Parameter(name, value);
    }

    public static Parameter param(String name, Collection<String> value) {
        return new Parameter(name, value);
    }

    public static Parameter param(NottableString name, Collection<NottableString> value) {
        return new Parameter(name, value);
    }

    public static Parameter schemaParam(String name, String ... values) {
        return new Parameter(NottableString.string(name), (NottableString[])Arrays.stream(values).map(NottableSchemaString::schemaString).toArray(NottableString[]::new));
    }

    public static Parameter schemaParam(NottableString name, String ... values) {
        return new Parameter(name, (NottableString[])Arrays.stream(values).map(NottableSchemaString::schemaString).toArray(NottableString[]::new));
    }

    public static Parameter optionalParam(String name, String ... values) {
        return new Parameter((NottableString)NottableOptionalString.optionalString(name), (NottableString[])Arrays.stream(values).map(NottableString::string).toArray(NottableString[]::new));
    }

    public Parameter withStyle(ParameterStyle style) {
        this.getName().withStyle(style);
        return this;
    }
}

