/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.NottableOptionalString;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.model.ParameterStyle;

public class NottableString
extends ObjectWithJsonToString
implements Comparable<NottableString> {
    public static final char NOT_CHAR = '!';
    private final String value;
    private final boolean isBlank;
    private final Boolean not;
    private final int hashCode;
    private final String json;
    private Pattern pattern;
    private Pattern lowercasePattern;
    private ParameterStyle parameterStyle;

    NottableString(String value, Boolean not) {
        this.value = value;
        this.isBlank = StringUtils.isBlank((CharSequence)value);
        this.not = not != null ? not : Boolean.FALSE;
        this.hashCode = Objects.hash(this.value, this.not);
        this.json = (this.isOptional() ? "?" : "") + (this.not != false ? "!" : "") + (!this.isBlank ? this.value : "");
    }

    NottableString(String value) {
        this.isBlank = StringUtils.isBlank((CharSequence)value);
        if (!this.isBlank && value.charAt(0) == '!') {
            this.value = value.substring(1);
            this.not = Boolean.TRUE;
        } else {
            this.value = value;
            this.not = Boolean.FALSE;
        }
        this.hashCode = Objects.hash(this.value, this.not);
        this.json = (this.isOptional() ? "?" : "") + (this.not != false ? "!" : "") + (!this.isBlank ? this.value : "");
    }

    public static List<NottableString> deserializeNottableStrings(String ... strings) {
        LinkedList<NottableString> nottableStrings = new LinkedList<NottableString>();
        for (String string : strings) {
            nottableStrings.add(NottableString.string(string));
        }
        return nottableStrings;
    }

    public static List<NottableString> deserializeNottableStrings(List<String> strings) {
        LinkedList<NottableString> nottableStrings = new LinkedList<NottableString>();
        for (String string : strings) {
            nottableStrings.add(NottableString.string(string));
        }
        return nottableStrings;
    }

    public static String serialiseNottableString(NottableString nottableString) {
        return nottableString.toString();
    }

    public static List<String> serialiseNottableString(Collection<NottableString> nottableStrings) {
        LinkedList<String> strings = new LinkedList<String>();
        for (NottableString nottableString : nottableStrings) {
            strings.add(nottableString.toString());
        }
        return strings;
    }

    public static NottableString string(String value, Boolean not) {
        return new NottableString(value, not);
    }

    public static NottableString string(String value) {
        Boolean not = null;
        boolean optional = false;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (value.charAt(0) == '?') {
                optional = true;
                value = value.substring(1);
            }
            if (value.charAt(0) == '!') {
                not = true;
                value = value.substring(1);
            }
            if (value.charAt(0) == '?') {
                optional = true;
                value = value.substring(1);
            }
        }
        if (optional) {
            return NottableOptionalString.optionalString(value, not);
        }
        return new NottableString(value, not);
    }

    public static NottableString not(String value) {
        return new NottableString(value, Boolean.TRUE);
    }

    public static List<NottableString> strings(String ... values) {
        ArrayList<NottableString> nottableValues = new ArrayList<NottableString>();
        if (values != null) {
            for (String value : values) {
                nottableValues.add(NottableString.string(value));
            }
        }
        return nottableValues;
    }

    public static List<NottableString> strings(Collection<String> values) {
        ArrayList<NottableString> nottableValues = new ArrayList<NottableString>();
        if (values != null) {
            for (String value : values) {
                nottableValues.add(NottableString.string(value));
            }
        }
        return nottableValues;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public boolean isNot() {
        return this.not;
    }

    public boolean isOptional() {
        return false;
    }

    public ParameterStyle getParameterStyle() {
        return this.parameterStyle;
    }

    public NottableString withStyle(ParameterStyle style) {
        if (style.equals((Object)ParameterStyle.DEEP_OBJECT)) {
            throw new IllegalArgumentException("deep object style is not supported");
        }
        this.parameterStyle = style;
        return this;
    }

    NottableString capitalize() {
        Object[] split = (this.value + "_").split("-");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtils.capitalize((String)split[i]);
        }
        return new NottableString(StringUtils.substringBeforeLast((String)Joiner.on((String)"-").join(split), (String)"_"), this.not);
    }

    public NottableString lowercase() {
        return new NottableString(this.value.toLowerCase(), this.not);
    }

    public boolean equalsIgnoreCase(Object other) {
        return this.equals(other, true);
    }

    private boolean equals(Object other, boolean ignoreCase) {
        if (other instanceof String) {
            if (ignoreCase) {
                return this.not.booleanValue() != ((String)other).equalsIgnoreCase(this.value);
            }
            return this.not.booleanValue() != other.equals(this.value);
        }
        if (other instanceof NottableString) {
            boolean reverse;
            NottableString that = (NottableString)other;
            if (that.getValue() == null) {
                return this.value == null;
            }
            boolean bl = reverse = that.not != this.not && (that.not != false || this.not != false);
            if (ignoreCase) {
                return reverse != that.getValue().equalsIgnoreCase(this.value);
            }
            return reverse != that.getValue().equals(this.value);
        }
        return false;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public boolean matches(String input) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.getValue());
        }
        return this.pattern.matcher(input).matches();
    }

    public boolean matchesIgnoreCase(String input) {
        if (this.lowercasePattern == null) {
            this.lowercasePattern = Pattern.compile(this.getValue().toLowerCase());
        }
        return this.lowercasePattern.matcher(input.toLowerCase()).matches();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof String) {
            return this.not.booleanValue() != other.equals(this.value);
        }
        if (this instanceof NottableSchemaString && other instanceof NottableSchemaString) {
            return this.equalsValue((NottableString)other);
        }
        if (this instanceof NottableSchemaString) {
            return this.equalsSchema((NottableSchemaString)this, (NottableString)other);
        }
        if (other instanceof NottableSchemaString) {
            return this.equalsSchema((NottableSchemaString)other, this);
        }
        if (other instanceof NottableString) {
            return this.equalsValue((NottableString)other);
        }
        return false;
    }

    private boolean equalsSchema(NottableSchemaString schema, NottableString string) {
        if (schema.getValue() == null && string.value == null) {
            return true;
        }
        if (schema.getValue() == null || string.value == null) {
            return false;
        }
        return schema.matches(string.value);
    }

    private boolean equalsString(NottableString one, NottableString two) {
        if (one.value == null && two.value == null) {
            return true;
        }
        if (one.value == null || two.value == null) {
            return false;
        }
        boolean reverse = two.not != one.not && (two.not != false || one.not != false);
        return reverse != two.value.equals(one.value);
    }

    private boolean equalsValue(NottableString other) {
        return this.equalsString(this, other);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.json;
    }

    @Override
    public int compareTo(NottableString other) {
        return other.getValue().compareTo(this.getValue());
    }
}

