/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.slf4j.event.Level;

public class XPathMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "stringToXmlDocumentParser", "xpathExpression"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private final StringToXmlDocumentParser stringToXmlDocumentParser;
    private XPathExpression xpathExpression;

    XPathMatcher(MockServerLogger mockServerLogger, String matcher) {
        block3: {
            this.stringToXmlDocumentParser = new StringToXmlDocumentParser();
            this.xpathExpression = null;
            this.mockServerLogger = mockServerLogger;
            this.matcher = matcher;
            if (StringUtils.isNotBlank((CharSequence)matcher)) {
                try {
                    this.xpathExpression = XPathFactory.newInstance().newXPath().compile(matcher);
                }
                catch (XPathExpressionException xpee) {
                    if (!MockServerLogger.isEnabled(Level.DEBUG)) break block3;
                    mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while creating xpath expression for{}assuming matcher not xpath{}").setArguments(matcher, xpee.getMessage()).setThrowable(xpee));
                }
            }
        }
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean alreadyLoggedMatchFailure;
        boolean result;
        block9: {
            result = false;
            alreadyLoggedMatchFailure = false;
            if (this.xpathExpression == null) {
                if (context != null) {
                    context.addDifference(this.mockServerLogger, "xpath match failed expected:{}found:{}failed because:{}", "null", matched, "xpath matcher was null");
                    alreadyLoggedMatchFailure = true;
                }
            } else if (this.matcher.equals(matched)) {
                result = true;
            } else if (matched != null) {
                try {
                    result = (Boolean)this.xpathExpression.evaluate(this.stringToXmlDocumentParser.buildDocument(matched, (matchedInException, throwable, level) -> {
                        if (context != null) {
                            context.addDifference(this.mockServerLogger, throwable, "xpath match failed expected:{}found:{}failed because " + StringToXmlDocumentParser.ErrorLevel.prettyPrint(level) + ":{}", this.matcher, matched, throwable.getMessage());
                        }
                    }), XPathConstants.BOOLEAN);
                }
                catch (Throwable throwable2) {
                    if (context == null) break block9;
                    context.addDifference(this.mockServerLogger, throwable2, "xpath match failed expected:{}found:{}failed because:{}", this.matcher, matched, throwable2.getMessage());
                    alreadyLoggedMatchFailure = true;
                }
            }
        }
        if (!result && !alreadyLoggedMatchFailure && context != null) {
            context.addDifference(this.mockServerLogger, "xpath match failed expected:{}found:{}failed because:{}", this.matcher, matched, "xpath did not evaluate to truthy");
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank((CharSequence)this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

