/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.codec.ExpandedParameterDecoder;
import org.mockserver.codec.JsonSchemaBodyDecoder;
import org.mockserver.codec.PathParametersDecoder;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.AbstractHttpRequestMatcher;
import org.mockserver.matchers.BinaryMatcher;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.BooleanMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.HashMapMatcher;
import org.mockserver.matchers.JsonPathMatcher;
import org.mockserver.matchers.JsonSchemaMatcher;
import org.mockserver.matchers.JsonStringMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.MatchDifferenceCount;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.matchers.ParameterStringMatcher;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.matchers.SubStringMatcher;
import org.mockserver.matchers.XPathMatcher;
import org.mockserver.matchers.XmlSchemaMatcher;
import org.mockserver.matchers.XmlStringMatcher;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonPathBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.NottableString;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.Parameters;
import org.mockserver.model.RegexBody;
import org.mockserver.model.RequestDefinition;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.deserializers.body.StrictBodyDTODeserializer;
import org.mockserver.serialization.model.BodyDTO;
import org.slf4j.event.Level;

public class HttpRequestPropertiesMatcher
extends AbstractHttpRequestMatcher {
    private static final String[] excludedFields = new String[]{"mockServerLogger", "methodMatcher", "pathMatcher", "pathParameterMatcher", "queryStringParameterMatcher", "bodyMatcher", "headerMatcher", "cookieMatcher", "keepAliveMatcher", "bodyDTOMatcher", "sslMatcher", "controlPlaneMatcher", "responseInProgress", "objectMapper"};
    private static final String COMMA = ",";
    private static final String REQUEST_NOT_OPERATOR_IS_ENABLED = "," + Character.NEW_LINE + "request 'not' operator is enabled";
    private static final String EXPECTATION_REQUEST_NOT_OPERATOR_IS_ENABLED = "," + Character.NEW_LINE + "expectation's request 'not' operator is enabled";
    private static final String EXPECTATION_REQUEST_MATCHER_NOT_OPERATOR_IS_ENABLED = "," + Character.NEW_LINE + "expectation's request matcher 'not' operator is enabled";
    private static final PathParametersDecoder pathParametersParser = new PathParametersDecoder();
    private static final ObjectWriter TO_STRING_OBJECT_WRITER = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private final ExpandedParameterDecoder expandedParameterDecoder;
    private int hashCode;
    private HttpRequest httpRequest;
    private List<HttpRequest> httpRequests;
    private RegexStringMatcher methodMatcher = null;
    private RegexStringMatcher pathMatcher = null;
    private MultiValueMapMatcher pathParameterMatcher = null;
    private MultiValueMapMatcher queryStringParameterMatcher = null;
    private BodyMatcher bodyMatcher = null;
    private MultiValueMapMatcher headerMatcher = null;
    private HashMapMatcher cookieMatcher = null;
    private BooleanMatcher keepAliveMatcher = null;
    private BooleanMatcher sslMatcher = null;
    private ObjectMapper objectMapperWithStrictBodyDTODeserializer = ObjectMapperFactory.createObjectMapper(new JsonDeserializer[]{new StrictBodyDTODeserializer()});
    private JsonSchemaBodyDecoder jsonSchemaBodyParser;
    private MatcherBuilder matcherBuilder;

    public HttpRequestPropertiesMatcher(MockServerLogger mockServerLogger) {
        super(mockServerLogger);
        this.expandedParameterDecoder = new ExpandedParameterDecoder(mockServerLogger);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public List<HttpRequest> getHttpRequests() {
        return this.httpRequests;
    }

    @Override
    public boolean apply(RequestDefinition requestDefinition) {
        HttpRequest httpRequest;
        HttpRequest httpRequest2 = httpRequest = requestDefinition instanceof HttpRequest ? (HttpRequest)requestDefinition : null;
        if (this.httpRequest == null || !this.httpRequest.equals(httpRequest)) {
            this.hashCode = 0;
            this.httpRequest = httpRequest;
            this.httpRequests = Collections.singletonList(this.httpRequest);
            if (httpRequest != null) {
                this.withMethod(httpRequest.getMethod());
                this.withPath(httpRequest);
                this.withPathParameters(httpRequest.getPathParameters());
                this.withQueryStringParameters(httpRequest.getQueryStringParameters());
                this.withBody(httpRequest.getBody());
                this.withHeaders(httpRequest.getHeaders());
                this.withCookies(httpRequest.getCookies());
                this.withKeepAlive(httpRequest.isKeepAlive());
                this.withSsl(httpRequest.isSecure());
                this.jsonSchemaBodyParser = new JsonSchemaBodyDecoder(this.mockServerLogger, this.expectation, httpRequest);
            }
            return true;
        }
        return false;
    }

    public HttpRequestPropertiesMatcher withControlPlaneMatcher(boolean controlPlaneMatcher) {
        this.controlPlaneMatcher = controlPlaneMatcher;
        return this;
    }

    private void withMethod(NottableString method) {
        this.methodMatcher = new RegexStringMatcher(this.mockServerLogger, method, this.controlPlaneMatcher);
    }

    private void withPath(HttpRequest httpRequest) {
        this.pathMatcher = new RegexStringMatcher(this.mockServerLogger, pathParametersParser.normalisePathWithParametersForMatching(httpRequest), this.controlPlaneMatcher);
    }

    private void withPathParameters(Parameters parameters) {
        this.pathParameterMatcher = new MultiValueMapMatcher(this.mockServerLogger, parameters, this.controlPlaneMatcher);
    }

    private void withQueryStringParameters(Parameters parameters) {
        this.queryStringParameterMatcher = new MultiValueMapMatcher(this.mockServerLogger, parameters, this.controlPlaneMatcher);
    }

    private void withBody(Body body) {
        this.bodyMatcher = this.buildBodyMatcher(body);
    }

    private BodyMatcher buildBodyMatcher(Body body) {
        BodyMatcher bodyMatcher = null;
        if (body != null) {
            switch (body.getType()) {
                case STRING: {
                    StringBody stringBody = (StringBody)body;
                    if (stringBody.isSubString()) {
                        bodyMatcher = new SubStringMatcher(this.mockServerLogger, NottableString.string(stringBody.getValue()));
                        break;
                    }
                    bodyMatcher = new ExactStringMatcher(this.mockServerLogger, NottableString.string(stringBody.getValue()));
                    break;
                }
                case REGEX: {
                    RegexBody regexBody = (RegexBody)body;
                    bodyMatcher = new RegexStringMatcher(this.mockServerLogger, NottableString.string(regexBody.getValue()), this.controlPlaneMatcher);
                    break;
                }
                case PARAMETERS: {
                    ParameterBody parameterBody = (ParameterBody)body;
                    bodyMatcher = new ParameterStringMatcher(this.mockServerLogger, parameterBody.getValue(), this.controlPlaneMatcher);
                    break;
                }
                case XPATH: {
                    XPathBody xPathBody = (XPathBody)body;
                    bodyMatcher = new XPathMatcher(this.mockServerLogger, xPathBody.getValue());
                    break;
                }
                case XML: {
                    XmlBody xmlBody = (XmlBody)body;
                    bodyMatcher = new XmlStringMatcher(this.mockServerLogger, xmlBody.getValue());
                    break;
                }
                case JSON: {
                    JsonBody jsonBody = (JsonBody)body;
                    bodyMatcher = new JsonStringMatcher(this.mockServerLogger, jsonBody.getValue(), jsonBody.getMatchType());
                    break;
                }
                case JSON_SCHEMA: {
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)body;
                    bodyMatcher = new JsonSchemaMatcher(this.mockServerLogger, jsonSchemaBody.getValue()).withParameterStyle(jsonSchemaBody.getParameterStyles());
                    break;
                }
                case JSON_PATH: {
                    JsonPathBody jsonPathBody = (JsonPathBody)body;
                    bodyMatcher = new JsonPathMatcher(this.mockServerLogger, jsonPathBody.getValue());
                    break;
                }
                case XML_SCHEMA: {
                    XmlSchemaBody xmlSchemaBody = (XmlSchemaBody)body;
                    bodyMatcher = new XmlSchemaMatcher(this.mockServerLogger, xmlSchemaBody.getValue());
                    break;
                }
                case BINARY: {
                    BinaryBody binaryBody = (BinaryBody)body;
                    bodyMatcher = new BinaryMatcher(this.mockServerLogger, binaryBody.getValue());
                }
            }
            if (body.isNot()) {
                bodyMatcher = HttpRequestPropertiesMatcher.notMatcher(bodyMatcher);
            }
        }
        return bodyMatcher;
    }

    private void withHeaders(Headers headers) {
        this.headerMatcher = new MultiValueMapMatcher(this.mockServerLogger, headers, this.controlPlaneMatcher);
    }

    private void withCookies(Cookies cookies) {
        this.cookieMatcher = new HashMapMatcher(this.mockServerLogger, cookies, this.controlPlaneMatcher);
    }

    private void withKeepAlive(Boolean keepAlive) {
        this.keepAliveMatcher = new BooleanMatcher(this.mockServerLogger, keepAlive);
    }

    private void withSsl(Boolean isSsl) {
        this.sslMatcher = new BooleanMatcher(this.mockServerLogger, isSsl);
    }

    @Override
    public boolean matches(MatchDifference matchDifference, RequestDefinition requestDefinition) {
        if (requestDefinition instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)requestDefinition;
            StringBuilder becauseBuilder = new StringBuilder();
            boolean overallMatch = this.matches(matchDifference, request, becauseBuilder);
            if (!this.controlPlaneMatcher) {
                if (overallMatch) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_MATCHED).setLogLevel(Level.INFO).setCorrelationId(requestDefinition.getLogCorrelationId()).setHttpRequest(request).setExpectation(this.expectation).setMessageFormat(this.expectation == null ? "request:{}matched request:{}" : "request:{}matched expectation:{}").setArguments(request, this.expectation == null ? this : this.expectation.clone()));
                } else {
                    becauseBuilder.replace(0, 1, "");
                    String because = becauseBuilder.toString();
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_NOT_MATCHED).setLogLevel(Level.INFO).setCorrelationId(requestDefinition.getLogCorrelationId()).setHttpRequest(request).setExpectation(this.expectation).setMessageFormat(this.expectation == null ? this.didNotMatchRequestBecause : (becauseBuilder.length() > 0 ? this.didNotMatchExpectationBecause : this.didNotMatchExpectationWithoutBecause)).setArguments(request, this.expectation == null ? this : this.expectation.clone(), because).setBecause(because));
                }
            }
            return overallMatch;
        }
        if (requestDefinition instanceof OpenAPIDefinition) {
            if (this.matcherBuilder == null) {
                this.matcherBuilder = new MatcherBuilder(this.mockServerLogger);
            }
            boolean overallMatch = false;
            for (HttpRequest request : this.matcherBuilder.transformsToMatcher(requestDefinition).getHttpRequests()) {
                if (!this.matches(request.cloneWithLogCorrelationId())) continue;
                overallMatch = true;
                break;
            }
            return overallMatch;
        }
        return requestDefinition == null;
    }

    private boolean matches(MatchDifference matchDifference, HttpRequest request, StringBuilder becauseBuilder) {
        if (this.isActive()) {
            if (request == this.httpRequest) {
                return true;
            }
            if (this.httpRequest == null) {
                return true;
            }
            if (MockServerLogger.isEnabled(Level.TRACE) && matchDifference == null) {
                matchDifference = new MatchDifference(request);
            }
            MatchDifferenceCount matchDifferenceCount = new MatchDifferenceCount(request);
            if (request != null) {
                boolean queryStringParametersMatches;
                Parameters pathParameters;
                boolean pathMatches;
                block20: {
                    boolean methodMatches;
                    boolean bl = methodMatches = StringUtils.isBlank((CharSequence)request.getMethod().getValue()) || this.matches(MatchDifference.Field.METHOD, matchDifference, this.methodMatcher, request.getMethod());
                    if (this.failFast(this.methodMatcher, matchDifference, matchDifferenceCount, becauseBuilder, methodMatches, MatchDifference.Field.METHOD)) {
                        return false;
                    }
                    pathMatches = StringUtils.isBlank((CharSequence)request.getPath().getValue()) || this.matches(MatchDifference.Field.PATH, matchDifference, this.pathMatcher, this.controlPlaneMatcher ? pathParametersParser.normalisePathWithParametersForMatching(request) : request.getPath());
                    pathParameters = null;
                    try {
                        pathParameters = this.controlPlaneMatcher ? pathParametersParser.extractPathParameters(request, this.httpRequest) : pathParametersParser.extractPathParameters(this.httpRequest, request);
                    }
                    catch (IllegalArgumentException iae) {
                        if (this.httpRequest.getPath().isBlank()) break block20;
                        if (matchDifference != null) {
                            matchDifference.currentField(MatchDifference.Field.PATH);
                            matchDifference.addDifference(this.mockServerLogger, iae.getMessage(), new Object[0]);
                        }
                        pathMatches = false;
                    }
                }
                if (this.failFast(this.pathMatcher, matchDifference, matchDifferenceCount, becauseBuilder, pathMatches, MatchDifference.Field.PATH)) {
                    return false;
                }
                boolean bodyMatches = this.bodyMatches(matchDifference, request);
                if (this.failFast(this.bodyMatcher, matchDifference, matchDifferenceCount, becauseBuilder, bodyMatches, MatchDifference.Field.BODY)) {
                    return false;
                }
                boolean headersMatch = this.matches(MatchDifference.Field.HEADERS, matchDifference, this.headerMatcher, request.getHeaders());
                if (this.failFast(this.headerMatcher, matchDifference, matchDifferenceCount, becauseBuilder, headersMatch, MatchDifference.Field.HEADERS)) {
                    return false;
                }
                boolean cookiesMatch = this.matches(MatchDifference.Field.COOKIES, matchDifference, this.cookieMatcher, request.getCookies());
                if (this.failFast(this.cookieMatcher, matchDifference, matchDifferenceCount, becauseBuilder, cookiesMatch, MatchDifference.Field.COOKIES)) {
                    return false;
                }
                boolean pathParametersMatches = true;
                if (!this.httpRequest.getPath().isBlank()) {
                    if (!this.controlPlaneMatcher) {
                        this.expandedParameterDecoder.splitParameters(this.httpRequest.getPathParameters(), request.getPathParameters());
                    }
                    MultiValueMapMatcher pathParameterMatcher = this.controlPlaneMatcher ? new MultiValueMapMatcher(this.mockServerLogger, request.getPathParameters(), this.controlPlaneMatcher) : this.pathParameterMatcher;
                    pathParametersMatches = this.matches(MatchDifference.Field.PATH_PARAMETERS, matchDifference, pathParameterMatcher, pathParameters);
                }
                if (this.failFast(this.pathParameterMatcher, matchDifference, matchDifferenceCount, becauseBuilder, pathParametersMatches, MatchDifference.Field.PATH_PARAMETERS)) {
                    return false;
                }
                if (!this.controlPlaneMatcher) {
                    this.expandedParameterDecoder.splitParameters(this.httpRequest.getQueryStringParameters(), request.getQueryStringParameters());
                }
                if (this.failFast(this.queryStringParameterMatcher, matchDifference, matchDifferenceCount, becauseBuilder, queryStringParametersMatches = this.matches(MatchDifference.Field.QUERY_PARAMETERS, matchDifference, this.queryStringParameterMatcher, request.getQueryStringParameters()), MatchDifference.Field.QUERY_PARAMETERS)) {
                    return false;
                }
                boolean keepAliveMatches = this.matches(MatchDifference.Field.KEEP_ALIVE, matchDifference, this.keepAliveMatcher, request.isKeepAlive());
                if (this.failFast(this.keepAliveMatcher, matchDifference, matchDifferenceCount, becauseBuilder, keepAliveMatches, MatchDifference.Field.KEEP_ALIVE)) {
                    return false;
                }
                boolean sslMatches = this.matches(MatchDifference.Field.SSL_MATCHES, matchDifference, this.sslMatcher, request.isSecure());
                if (this.failFast(this.sslMatcher, matchDifference, matchDifferenceCount, becauseBuilder, sslMatches, MatchDifference.Field.SSL_MATCHES)) {
                    return false;
                }
                return HttpRequestPropertiesMatcher.combinedResultAreTrue(matchDifferenceCount.getFailures() == 0, request.isNot(), this.httpRequest.isNot(), this.not);
            }
            return HttpRequestPropertiesMatcher.combinedResultAreTrue(true, this.httpRequest.isNot(), this.not);
        }
        return false;
    }

    private boolean failFast(Matcher<?> matcher, MatchDifference matchDifference, MatchDifferenceCount matchDifferenceCount, StringBuilder becauseBuilder, boolean fieldMatches, MatchDifference.Field fieldName) {
        if (!this.controlPlaneMatcher) {
            becauseBuilder.append(Character.NEW_LINE).append(fieldName.getName()).append(fieldMatches ? " matched" : " didn't match");
            if (matchDifference != null && matchDifference.getDifferences(fieldName) != null && !matchDifference.getDifferences(fieldName).isEmpty()) {
                becauseBuilder.append(COLON_NEW_LINES).append(Joiner.on((String)Character.NEW_LINE).join(matchDifference.getDifferences(fieldName)));
            }
        }
        if (!fieldMatches && !this.controlPlaneMatcher) {
            if (matchDifferenceCount.getHttpRequest().isNot()) {
                becauseBuilder.append(REQUEST_NOT_OPERATOR_IS_ENABLED);
            }
            if (this.httpRequest.isNot()) {
                becauseBuilder.append(EXPECTATION_REQUEST_NOT_OPERATOR_IS_ENABLED);
            }
            if (this.not) {
                becauseBuilder.append(EXPECTATION_REQUEST_MATCHER_NOT_OPERATOR_IS_ENABLED);
            }
        }
        if (!fieldMatches) {
            matchDifferenceCount.incrementFailures();
        }
        if (matcher != null && !matcher.isBlank() && ConfigurationProperties.matchersFailFast()) {
            return HttpRequestPropertiesMatcher.combinedResultAreTrue(matchDifferenceCount.getFailures() != 0, matchDifferenceCount.getHttpRequest().isNot(), this.httpRequest.isNot(), this.not);
        }
        return false;
    }

    private static boolean combinedResultAreTrue(boolean ... inputs) {
        int count = 0;
        for (boolean input : inputs) {
            count += input ? 1 : 0;
        }
        return count % 2 != 0;
    }

    private boolean bodyMatches(MatchDifference context, HttpRequest request) {
        boolean bodyMatches;
        block13: {
            if (this.bodyMatcher != null) {
                if (this.controlPlaneMatcher) {
                    if (this.httpRequest.getBody() != null && String.valueOf(this.httpRequest.getBody()).equalsIgnoreCase(String.valueOf(request.getBody()))) {
                        bodyMatches = true;
                    } else if (this.bodyMatches(this.bodyMatcher, context, request)) {
                        bodyMatches = true;
                    } else if (StringUtils.isNotBlank((CharSequence)request.getBodyAsJsonOrXmlString())) {
                        try {
                            BodyDTO bodyDTO = (BodyDTO)this.objectMapperWithStrictBodyDTODeserializer.readValue(request.getBodyAsJsonOrXmlString(), BodyDTO.class);
                            if (bodyDTO != null) {
                                bodyMatches = this.bodyMatches(this.buildBodyMatcher((Body)bodyDTO.buildObject()), context, this.httpRequest);
                                break block13;
                            }
                            bodyMatches = false;
                        }
                        catch (Throwable ignore) {
                            bodyMatches = false;
                        }
                    } else {
                        bodyMatches = false;
                    }
                } else {
                    bodyMatches = this.bodyMatches(this.bodyMatcher, context, request);
                }
            } else {
                bodyMatches = true;
            }
        }
        return bodyMatches;
    }

    private boolean bodyMatches(BodyMatcher bodyMatcher, MatchDifference context, HttpRequest request) {
        boolean bodyMatches;
        if (this.httpRequest.getBody().getOptional() != null && this.httpRequest.getBody().getOptional().booleanValue() && request.getBody() == null) {
            bodyMatches = true;
        } else if (bodyMatcher instanceof BinaryMatcher) {
            bodyMatches = this.matches(MatchDifference.Field.BODY, context, bodyMatcher, request.getBodyAsRawBytes());
        } else if (bodyMatcher instanceof ExactStringMatcher || bodyMatcher instanceof SubStringMatcher || bodyMatcher instanceof RegexStringMatcher) {
            bodyMatches = this.matches(MatchDifference.Field.BODY, context, bodyMatcher, NottableString.string(request.getBodyAsString()));
        } else if (bodyMatcher instanceof XmlStringMatcher || bodyMatcher instanceof XmlSchemaMatcher) {
            bodyMatches = this.matches(MatchDifference.Field.BODY, context, bodyMatcher, request.getBodyAsString());
        } else if (bodyMatcher instanceof JsonStringMatcher || bodyMatcher instanceof JsonSchemaMatcher || bodyMatcher instanceof JsonPathMatcher) {
            try {
                bodyMatches = this.matches(MatchDifference.Field.BODY, context, bodyMatcher, this.jsonSchemaBodyParser.convertToJson(request, bodyMatcher));
            }
            catch (IllegalArgumentException iae) {
                if (context != null) {
                    context.addDifference(this.mockServerLogger, iae, iae.getMessage(), new Object[0]);
                }
                bodyMatches = this.matches(MatchDifference.Field.BODY, context, bodyMatcher, request.getBodyAsString());
            }
        } else {
            bodyMatches = this.matches(MatchDifference.Field.BODY, context, bodyMatcher, request.getBodyAsString());
        }
        return bodyMatches;
    }

    private <T> boolean matches(MatchDifference.Field field, MatchDifference context, Matcher<T> matcher, T t) {
        if (context != null) {
            context.currentField(field);
        }
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(context, t)) {
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        try {
            return TO_STRING_OBJECT_WRITER.writeValueAsString((Object)this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpRequestPropertiesMatcher that = (HttpRequestPropertiesMatcher)o;
        return Objects.equals(this.httpRequest, that.httpRequest);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.httpRequest);
        }
        return this.hashCode;
    }
}

