/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeysAndValues;

public class HashMapMatcher
extends NotMatcher<KeysAndValues> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final CaseInsensitiveRegexHashMap matcher;
    private final KeysAndValues keysAndValues;
    private final boolean controlPlaneMatcher;
    private Boolean allKeysNotted;
    private Boolean allKeysOptional;

    HashMapMatcher(MockServerLogger mockServerLogger, KeysAndValues keysAndValues, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.keysAndValues = keysAndValues;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = keysAndValues != null ? keysAndValues.toCaseInsensitiveRegexMultiMap(mockServerLogger, controlPlaneMatcher) : null;
    }

    @Override
    public boolean matches(MatchDifference context, KeysAndValues matched) {
        boolean result;
        if (this.matcher == null || this.matcher.isEmpty()) {
            result = true;
        } else if (matched == null || matched.isEmpty()) {
            if (this.allKeysNotted == null) {
                this.allKeysNotted = this.matcher.allKeysNotted();
            }
            if (this.allKeysOptional == null) {
                this.allKeysOptional = this.matcher.allKeysOptional();
            }
            result = this.allKeysNotted != false || this.allKeysOptional != false;
        } else {
            result = matched.toCaseInsensitiveRegexMultiMap(this.mockServerLogger, this.controlPlaneMatcher).containsAll(this.matcher, context != null ? context.getLogCorrelationId() : null);
        }
        if (!result && context != null) {
            context.addDifference(this.mockServerLogger, "map subset match failed expected:{}found:{}failed because:{}", this.keysAndValues, matched != null ? matched : "none", matched != null ? "map is not a subset" : "none is not a subset");
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.isEmpty();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

