/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Function;

public class CircularPriorityQueue<K, V>
extends PriorityBlockingQueue<V> {
    private int maxSize;
    private final Class<V> valueType;
    private final Function<V, K> keyFunction;
    private ConcurrentLinkedQueue<V> insertionOrderQueue = new ConcurrentLinkedQueue();
    private ConcurrentMap<K, V> byKey = new ConcurrentHashMap();

    public CircularPriorityQueue(int maxSize, Class<V> valueType, Comparator<? super V> comparator, Function<V, K> keyFunction) {
        super(50, comparator);
        this.maxSize = maxSize;
        this.valueType = valueType;
        this.keyFunction = keyFunction;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean addAll(Collection<? extends V> collection) {
        if (this.maxSize > 0) {
            boolean result = false;
            for (V element : collection) {
                if (!this.add(element)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean offer(V element) {
        if (this.maxSize > 0) {
            boolean updated = super.offer(element);
            this.insertionOrderQueue.offer(element);
            this.byKey.put(this.keyFunction.apply(element), element);
            while (this.insertionOrderQueue.size() > this.maxSize) {
                V elementToRemove = this.insertionOrderQueue.poll();
                super.remove(elementToRemove);
                this.byKey.remove(this.keyFunction.apply(elementToRemove));
            }
            return updated;
        }
        return false;
    }

    @Override
    public boolean remove(Object elementToRemove) {
        if (this.valueType.isAssignableFrom(elementToRemove.getClass())) {
            this.byKey.remove(this.keyFunction.apply(this.valueType.cast(elementToRemove)));
            this.insertionOrderQueue.remove(elementToRemove);
            return super.remove(elementToRemove);
        }
        return false;
    }

    public List<V> toSortedList() {
        PriorityBlockingQueue secondQueue = new PriorityBlockingQueue(this);
        ArrayList contents = new ArrayList(secondQueue.size());
        while (secondQueue.size() > 0) {
            contents.add(secondQueue.poll());
        }
        return contents;
    }

    public Optional<V> getByKey(K key) {
        return Optional.ofNullable(this.byKey.get(key));
    }

    public Map<K, V> keyMap() {
        return new HashMap<K, V>(this.byKey);
    }
}

