/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.mockserver.collections.CaseInsensitiveNottableRegexListHashMap;
import org.mockserver.collections.ImmutableEntry;
import org.mockserver.collections.SubSets;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.KeyMatchStyle;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.slf4j.event.Level;

public class CaseInsensitiveRegexMultiMap
extends ObjectWithReflectiveEqualsHashCodeToString
implements Map<NottableString, NottableString> {
    private final CaseInsensitiveNottableRegexListHashMap backingMap;
    private final RegexStringMatcher regexStringMatcher;
    private final MockServerLogger mockServerLogger;
    private final KeyMatchStyle keyMatchStyle;
    private boolean noOptionals = true;

    public CaseInsensitiveRegexMultiMap(MockServerLogger mockServerLogger, boolean controlPlaneMatcher) {
        this(mockServerLogger, controlPlaneMatcher, KeyMatchStyle.SUB_SET);
    }

    public CaseInsensitiveRegexMultiMap(MockServerLogger mockServerLogger, boolean controlPlaneMatcher, KeyMatchStyle keyMatchStyle) {
        this.mockServerLogger = mockServerLogger;
        this.keyMatchStyle = keyMatchStyle;
        this.regexStringMatcher = new RegexStringMatcher(mockServerLogger, controlPlaneMatcher);
        this.backingMap = new CaseInsensitiveNottableRegexListHashMap(mockServerLogger, controlPlaneMatcher);
    }

    @VisibleForTesting
    public static CaseInsensitiveRegexMultiMap multiMap(boolean controlPlaneMatcher, KeyMatchStyle keyMatchStyle, String[] ... keyAndValues) {
        CaseInsensitiveRegexMultiMap multiMap = new CaseInsensitiveRegexMultiMap(new MockServerLogger(), controlPlaneMatcher, keyMatchStyle);
        for (String[] keyAndValue : keyAndValues) {
            for (int i = 1; i < keyAndValue.length; ++i) {
                multiMap.put(keyAndValue[0], keyAndValue[i]);
            }
        }
        return multiMap;
    }

    @VisibleForTesting
    public static CaseInsensitiveRegexMultiMap multiMap(boolean controlPlaneMatcher, KeyMatchStyle keyMatchStyle, NottableString[] ... keyAndValues) {
        CaseInsensitiveRegexMultiMap multiMap = new CaseInsensitiveRegexMultiMap(new MockServerLogger(), controlPlaneMatcher, keyMatchStyle);
        for (NottableString[] keyAndValue : keyAndValues) {
            for (int i = 1; i < keyAndValue.length; ++i) {
                multiMap.put(keyAndValue[0], keyAndValue[i]);
            }
        }
        return multiMap;
    }

    public boolean isNoOptionals() {
        return this.noOptionals;
    }

    public boolean containsAll(CaseInsensitiveRegexMultiMap matcher) {
        return this.containsAll(matcher, null);
    }

    public boolean containsAll(CaseInsensitiveRegexMultiMap matcher, String logCorrelationId) {
        switch (matcher.keyMatchStyle) {
            case SUB_SET: {
                List<ImmutableEntry> matchedEntries = this.entryList();
                Multimap<Integer, List<ImmutableEntry>> allMatchedSubSets = SubSets.distinctSubSetsMap(matchedEntries, ArrayListMultimap.create(), matchedEntries.size() - 1);
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("attempting to match subset from{}against multimap{}").setArguments(allMatchedSubSets, matcher.entryList()));
                }
                if (this.isEmpty() && matcher.allKeysNotted()) {
                    return true;
                }
                if (this.noOptionals && matcher.isNoOptionals()) {
                    List<ImmutableEntry> matcherEntries = matcher.entryList();
                    for (List matchedSubSet : allMatchedSubSets.get((Object)matcherEntries.size())) {
                        if (!ImmutableEntry.listsEqual(matcherEntries, matchedSubSet)) continue;
                        if (MockServerLogger.isEnabled(Level.TRACE)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("multimap{}containsAll subset{}in{}").setArguments(this, matchedSubSet, matcherEntries));
                        }
                        return true;
                    }
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("multimap{}containsAll found no subset equal to{}from{}").setArguments(this, matcherEntries, allMatchedSubSets));
                    }
                } else {
                    boolean result = false;
                    List matcherEntriesWithoutOptionals = matcher.entryList().stream().filter(entry -> !((NottableString)entry.getKey()).isOptional()).collect(Collectors.toList());
                    for (Collection matchedSubSet : allMatchedSubSets.get((Object)matcherEntriesWithoutOptionals.size())) {
                        if (!ImmutableEntry.listsEqual(matcherEntriesWithoutOptionals, matchedSubSet)) continue;
                        if (MockServerLogger.isEnabled(Level.TRACE)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("multimap{}containsAll subset of non-optionals{}in{}").setArguments(this, matchedSubSet, matcherEntriesWithoutOptionals));
                        }
                        result = true;
                    }
                    if (result) {
                        List optionalMatcherEntries = matcher.entryList().stream().filter(entry -> ((NottableString)entry.getKey()).isOptional()).collect(Collectors.toList());
                        if (!optionalMatcherEntries.isEmpty()) {
                            Collection matchedSubSet;
                            matchedSubSet = new HashSet();
                            for (ImmutableEntry optionalMatcherEntry : optionalMatcherEntries) {
                                List<NottableString> matchedValuesForKey = this.getAll((NottableString)optionalMatcherEntry.getKey());
                                boolean matchesValue = false;
                                if (matchedValuesForKey.isEmpty()) {
                                    matchesValue = true;
                                }
                                for (NottableString matchedValue : matchedValuesForKey) {
                                    if (!this.regexStringMatcher.matches((NottableString)optionalMatcherEntry.getValue(), matchedValue, true)) continue;
                                    matchesValue = true;
                                    break;
                                }
                                if (matchesValue) continue;
                                if (MockServerLogger.isEnabled(Level.TRACE)) {
                                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("multimap{}matching by subset failed to match optional{}with any value from{}").setArguments(this, optionalMatcherEntry, matchedValuesForKey));
                                }
                                return false;
                            }
                            if (MockServerLogger.isEnabled(Level.TRACE)) {
                                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("multimap{}containsAll subset of optionals{}in{}").setArguments(this, matchedSubSet, optionalMatcherEntries));
                            }
                            return true;
                        }
                        return true;
                    }
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("multimap{}containsAll found no subset equal to{}from{}").setArguments(this, matcher.entryList(), matchedEntries));
                    }
                }
                return false;
            }
            case MATCHING_KEY: {
                for (NottableString matcherKey : matcher.keySet()) {
                    List<NottableString> matcherValuesForKey = matcher.getAll(matcherKey);
                    List<NottableString> matchedValuesForKey = this.getAll(matcherKey);
                    if (matchedValuesForKey.isEmpty() && !matcherKey.isOptional()) {
                        if (MockServerLogger.isEnabled(Level.TRACE)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("multimap{}containsAll matching by key found no matching values for{}").setArguments(this, matcherKey));
                        }
                        return false;
                    }
                    for (NottableString matchedValue : matchedValuesForKey) {
                        boolean matchesValue = false;
                        for (NottableString matcherValue : matcherValuesForKey) {
                            if (!this.regexStringMatcher.matches(matcherValue, matchedValue, true)) continue;
                            matchesValue = true;
                            break;
                        }
                        if (matchesValue) continue;
                        if (MockServerLogger.isEnabled(Level.TRACE)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setCorrelationId(logCorrelationId).setMessageFormat("multimap{}containsAll matching by key found non-matching value{}for{}").setArguments(this, matchedValue, matcherValuesForKey));
                        }
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean allKeysNotted() {
        if (!this.isEmpty()) {
            for (NottableString key : this.keySet()) {
                if (key.isNot()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean allKeysOptional() {
        if (!this.isEmpty()) {
            for (NottableString key : this.keySet()) {
                if (key.isOptional()) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean containsKeyValue(String key, String value) {
        return this.containsKeyValue(NottableString.string(key), NottableString.string(value));
    }

    public synchronized boolean containsKeyValue(NottableString key, NottableString value) {
        if (!this.isEmpty()) {
            for (NottableString valueToMatch : this.getAll(key)) {
                if (!this.regexStringMatcher.matches(value, valueToMatch, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        if (!this.isEmpty()) {
            if (value instanceof NottableString) {
                for (NottableString key : this.backingMap.keySet()) {
                    for (List<NottableString> allKeyValues : this.backingMap.getAll(key)) {
                        for (NottableString keyValue : allKeyValues) {
                            if (!this.regexStringMatcher.matches(keyValue, (NottableString)value, true)) continue;
                            return true;
                        }
                    }
                }
            } else if (value instanceof String) {
                return this.containsValue(NottableString.string((String)value));
            }
        }
        return false;
    }

    @Override
    public synchronized NottableString get(Object key) {
        if (!this.isEmpty()) {
            if (key instanceof String) {
                return this.get(NottableString.string((String)key));
            }
            Object values = this.backingMap.get(key);
            if (values != null && values.size() > 0) {
                return (NottableString)values.get(0);
            }
            return null;
        }
        return null;
    }

    public synchronized List<NottableString> getAll(String key) {
        return this.getAll(NottableString.string(key));
    }

    public synchronized List<NottableString> getAll(NottableString key) {
        if (!this.isEmpty()) {
            ArrayList<NottableString> all = new ArrayList<NottableString>();
            for (List<NottableString> subList : this.backingMap.getAll(key)) {
                all.addAll(subList);
            }
            return all;
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized NottableString put(String key, String value) {
        return this.put(NottableString.string(key), NottableString.string(value));
    }

    @Override
    public synchronized NottableString put(NottableString key, NottableString value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        List<Object> list = Collections.synchronizedList(new ArrayList());
        for (ImmutableEntry entry : this.entryList()) {
            if (!EqualsBuilder.reflectionEquals((Object)entry.getKey(), (Object)key, (String[])new String[]{"key"})) continue;
            if (key.isOptional()) {
                throw new IllegalArgumentException("multiple values for optional key are not allowed, value \"" + entry.getValue() + "\" already exists for \"" + key + "\"");
            }
            list.add(entry.getValue());
        }
        list.add(value);
        if (key.isOptional()) {
            this.noOptionals = false;
        }
        this.backingMap.put(key, list);
        return value;
    }

    @Override
    public synchronized List<NottableString> put(String key, List<String> values) {
        return this.put(NottableString.string(key), NottableString.strings(values));
    }

    @Override
    public synchronized List<NottableString> put(NottableString key, List<NottableString> values) {
        if (this.containsKey(key)) {
            for (NottableString value : values) {
                this.put(key, value);
            }
        } else {
            this.backingMap.put(key, values);
        }
        return values;
    }

    @Override
    public synchronized NottableString remove(Object key) {
        if (!this.isEmpty()) {
            if (key instanceof String) {
                return this.remove(NottableString.string((String)key));
            }
            Object values = this.backingMap.get(key);
            if (values != null && values.size() > 0) {
                NottableString removed = (NottableString)values.remove(0);
                if (values.size() == 0) {
                    this.backingMap.remove(key);
                }
                return removed;
            }
            return null;
        }
        return null;
    }

    public synchronized List<NottableString> removeAll(NottableString key) {
        return this.backingMap.remove(key);
    }

    public synchronized List<NottableString> removeAll(String key) {
        return this.backingMap.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends NottableString, ? extends NottableString> map) {
        for (Map.Entry<? extends NottableString, ? extends NottableString> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        this.backingMap.clear();
    }

    @Override
    public synchronized Set<NottableString> keySet() {
        if (!this.isEmpty()) {
            return this.backingMap.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public synchronized Collection<NottableString> values() {
        if (!this.isEmpty()) {
            ArrayList<NottableString> values = new ArrayList<NottableString>();
            for (List valuesForKey : this.backingMap.values()) {
                values.addAll(valuesForKey);
            }
            return values;
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized int size() {
        return this.backingMap.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public synchronized Set<Map.Entry<NottableString, NottableString>> entrySet() {
        if (!this.isEmpty()) {
            LinkedHashSet<Map.Entry<NottableString, NottableString>> entrySet = new LinkedHashSet<Map.Entry<NottableString, NottableString>>();
            for (Map.Entry entry : this.backingMap.entrySet()) {
                for (NottableString value : (List)entry.getValue()) {
                    entrySet.add(ImmutableEntry.entry(this.regexStringMatcher, (NottableString)entry.getKey(), value));
                }
            }
            return entrySet;
        }
        return Collections.emptySet();
    }

    public synchronized List<ImmutableEntry> entryList() {
        if (!this.isEmpty()) {
            ArrayList<ImmutableEntry> entrySet = new ArrayList<ImmutableEntry>();
            for (Map.Entry entry : this.backingMap.entrySet()) {
                for (NottableString value : (List)entry.getValue()) {
                    entrySet.add(ImmutableEntry.entry(this.regexStringMatcher, (NottableString)entry.getKey(), value));
                }
            }
            return entrySet;
        }
        return Collections.emptyList();
    }
}

