/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver;

import org.apache.commons.lang3.StringUtils;

public final class Version {
    private static final String VERSION = "5.11.0";
    private static final String GROUPID = "org.mock-server";
    private static final String ARTIFACTID = "mockserver-core";
    private static String majorMinorVersion = null;

    private static String getValue(String value, String defaultValue) {
        if (!value.startsWith("$")) {
            return value;
        }
        return defaultValue;
    }

    public static String getVersion() {
        return Version.getValue(VERSION, System.getProperty("MOCKSERVER_VERSION", ""));
    }

    public static String getMajorMinorVersion() {
        if (majorMinorVersion == null) {
            majorMinorVersion = StringUtils.substringBeforeLast((String)Version.getValue(VERSION, System.getProperty("MOCKSERVER_VERSION", "")), (String)".");
        }
        return majorMinorVersion;
    }

    public static boolean matchesMajorMinorVersion(String version) {
        boolean matches = true;
        if (StringUtils.isNotBlank((CharSequence)version) && StringUtils.isNotBlank((CharSequence)Version.getMajorMinorVersion())) {
            matches = Version.getMajorMinorVersion().equals(StringUtils.substringBeforeLast((String)version, (String)"."));
        }
        return matches;
    }

    public static String getGroupId() {
        return Version.getValue(GROUPID, "");
    }

    public static String getArtifactId() {
        return Version.getValue(ARTIFACTID, "");
    }
}

