/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.StringBody;
import org.mockserver.serialization.model.BodyWithContentTypeDTO;

public class StringBodyDTO
extends BodyWithContentTypeDTO {
    private final String string;
    private final boolean subString;
    private final byte[] rawBytes;

    public StringBodyDTO(StringBody stringBody) {
        this(stringBody, stringBody.getNot());
    }

    public StringBodyDTO(StringBody stringBody, Boolean not) {
        super(stringBody.getType(), not, stringBody.getContentType());
        this.string = stringBody.getValue();
        this.subString = stringBody.isSubString();
        this.rawBytes = stringBody.getRawBytes();
    }

    public String getString() {
        return this.string;
    }

    public boolean isSubString() {
        return this.subString;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Override
    public StringBody buildObject() {
        return new StringBody(this.getString(), this.getRawBytes(), this.isSubString(), this.getMediaType());
    }
}

