/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.slf4j.event.Level;

public class LogEventJsonSerializer
implements Serializer<LogEntry> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);

    public LogEventJsonSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    @Override
    public String serialize(LogEntry messageLogEntry) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)messageLogEntry);
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while serializing messageLogEntry to JSON with value " + messageLogEntry).setThrowable(e));
            throw new RuntimeException("Exception while serializing messageLogEntry to JSON with value " + messageLogEntry, e);
        }
    }

    @Override
    public String serialize(List<LogEntry> messageLogEntries) {
        return this.serialize(messageLogEntries.toArray(new LogEntry[0]));
    }

    @Override
    public String serialize(LogEntry ... messageLogEntries) {
        try {
            if (messageLogEntries != null && messageLogEntries.length > 0) {
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)messageLogEntries);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while serializing LogEntry to JSON with value " + Arrays.asList(messageLogEntries)).setThrowable(e));
            throw new RuntimeException("Exception while serializing LogEntry to JSON with value " + Arrays.asList(messageLogEntries), e);
        }
    }

    @Override
    public LogEntry deserialize(String jsonLogEntry) {
        LogEntry messageLogEntry = null;
        if (jsonLogEntry != null && !jsonLogEntry.isEmpty()) {
            try {
                messageLogEntry = (LogEntry)this.objectMapper.readValue(jsonLogEntry, LogEntry.class);
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for LogEntry").setArguments(jsonLogEntry).setThrowable(e));
                throw new RuntimeException("Exception while parsing LogEntry for [" + jsonLogEntry + "]", e);
            }
        }
        return messageLogEntry;
    }

    @Override
    public Class<LogEntry> supportsType() {
        return LogEntry.class;
    }
}

