/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BinaryMatcher;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.BooleanMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.HashMapMatcher;
import org.mockserver.matchers.JsonPathMatcher;
import org.mockserver.matchers.JsonSchemaMatcher;
import org.mockserver.matchers.JsonStringMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.matchers.ParameterStringMatcher;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.matchers.SubStringMatcher;
import org.mockserver.matchers.XPathMatcher;
import org.mockserver.matchers.XmlSchemaMatcher;
import org.mockserver.matchers.XmlStringMatcher;
import org.mockserver.mock.Expectation;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonPathBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.NottableString;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.Parameters;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.JsonPathBodyDTO;
import org.mockserver.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.serialization.model.ParameterBodyDTO;
import org.mockserver.serialization.model.RegexBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XPathBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;
import org.mockserver.serialization.model.XmlSchemaBodyDTO;
import org.slf4j.event.Level;

public class HttpRequestMatcher
extends NotMatcher<HttpRequest> {
    public static final Comparator<? super HttpRequestMatcher> EXPECTATION_PRIORITY_COMPARATOR = Comparator.comparing(HttpRequestMatcher::getExpectation, Expectation.EXPECTATION_PRIORITY_COMPARATOR);
    private static final String[] excludedFields = new String[]{"mockServerLogger", "objectMapper"};
    private static final String DID_NOT_MATCH = "didn't match";
    private static final String MATCHED = "matched";
    private static final String REQUEST_DID_NOT_MATCH = "request:{}didn't match request matcher:{}because:{}";
    private static final String EXPECTATION_DID_NOT_MATCH = "request:{}didn't match expectation:{}because:{}";
    private static final String EXPECTATION_DID_NOT_MATCH_WITHOUT_BECAUSE = "request:{}didn't match expectation:{}";
    private static final String REQUEST_DID_MATCH = "request:{}matched request:{}";
    private static final String EXPECTATION_DID_MATCH = "request:{}matched expectation:{}";
    private static final String SPACE = " ";
    private static final String SSL_MATCHES = "sslMatches";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String QUERY = "query";
    private static final String COOKIES = "cookies";
    private static final String HEADERS = "headers";
    private static final String BODY = "body";
    private static final String PATH = "path";
    private static final String METHOD = "method";
    private static final String COMMA = ",";
    private static final String EMPTY = "";
    private MockServerLogger mockServerLogger;
    private Expectation expectation;
    private HttpRequest httpRequest;
    private RegexStringMatcher methodMatcher = null;
    private RegexStringMatcher pathMatcher = null;
    private MultiValueMapMatcher queryStringParameterMatcher = null;
    private BodyMatcher bodyMatcher = null;
    private MultiValueMapMatcher headerMatcher = null;
    private HashMapMatcher cookieMatcher = null;
    private BooleanMatcher keepAliveMatcher = null;
    private BodyDTO bodyDTOMatcher = null;
    private BooleanMatcher sslMatcher = null;
    private boolean controlPlaneMatcher;
    private boolean responseInProgress = false;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);

    public HttpRequestMatcher(MockServerLogger mockServerLogger, HttpRequest httpRequest) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneMatcher = true;
        this.update(httpRequest);
    }

    public boolean update(HttpRequest httpRequest) {
        if (this.httpRequest != null && this.httpRequest.equals(httpRequest)) {
            return false;
        }
        this.httpRequest = httpRequest;
        if (httpRequest != null) {
            this.withMethod(httpRequest.getMethod());
            this.withPath(httpRequest.getPath());
            this.withQueryStringParameters(httpRequest.getQueryStringParameters());
            this.withBody(httpRequest.getBody());
            this.withHeaders(httpRequest.getHeaders());
            this.withCookies(httpRequest.getCookies());
            this.withKeepAlive(httpRequest.isKeepAlive());
            this.withSsl(httpRequest.isSecure());
        }
        return true;
    }

    HttpRequestMatcher(MockServerLogger mockServerLogger, Expectation expectation) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneMatcher = false;
        this.update(expectation);
    }

    public boolean update(Expectation expectation) {
        if (this.expectation != null && this.expectation.equals(expectation)) {
            return false;
        }
        this.expectation = expectation;
        this.update(expectation.getHttpRequest());
        return true;
    }

    public HttpRequestMatcher withControlPlaneMatcher(boolean controlPlaneMatcher) {
        this.controlPlaneMatcher = controlPlaneMatcher;
        return this;
    }

    public boolean isResponseInProgress() {
        return this.responseInProgress;
    }

    public HttpRequestMatcher setResponseInProgress(boolean responseInProgress) {
        this.responseInProgress = responseInProgress;
        return this;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    private void withMethod(NottableString method) {
        this.methodMatcher = new RegexStringMatcher(this.mockServerLogger, method, this.controlPlaneMatcher);
    }

    private void withPath(NottableString path) {
        this.pathMatcher = new RegexStringMatcher(this.mockServerLogger, path, this.controlPlaneMatcher);
    }

    private void withQueryStringParameters(Parameters parameters) {
        this.queryStringParameterMatcher = new MultiValueMapMatcher(this.mockServerLogger, parameters, this.controlPlaneMatcher);
    }

    private void withBody(Body body) {
        if (body != null) {
            switch (body.getType()) {
                case STRING: {
                    StringBody stringBody = (StringBody)body;
                    this.bodyDTOMatcher = new StringBodyDTO(stringBody);
                    if (stringBody.isSubString()) {
                        this.bodyMatcher = new SubStringMatcher(this.mockServerLogger, NottableString.string(stringBody.getValue()));
                        break;
                    }
                    this.bodyMatcher = new ExactStringMatcher(this.mockServerLogger, NottableString.string(stringBody.getValue()));
                    break;
                }
                case REGEX: {
                    RegexBody regexBody = (RegexBody)body;
                    this.bodyDTOMatcher = new RegexBodyDTO(regexBody);
                    this.bodyMatcher = new RegexStringMatcher(this.mockServerLogger, NottableString.string(regexBody.getValue()), this.controlPlaneMatcher);
                    break;
                }
                case PARAMETERS: {
                    ParameterBody parameterBody = (ParameterBody)body;
                    this.bodyDTOMatcher = new ParameterBodyDTO(parameterBody);
                    this.bodyMatcher = new ParameterStringMatcher(this.mockServerLogger, parameterBody.getValue(), this.controlPlaneMatcher);
                    break;
                }
                case XPATH: {
                    XPathBody xPathBody = (XPathBody)body;
                    this.bodyDTOMatcher = new XPathBodyDTO(xPathBody);
                    this.bodyMatcher = new XPathMatcher(this.mockServerLogger, xPathBody.getValue());
                    break;
                }
                case XML: {
                    XmlBody xmlBody = (XmlBody)body;
                    this.bodyDTOMatcher = new XmlBodyDTO(xmlBody);
                    this.bodyMatcher = new XmlStringMatcher(this.mockServerLogger, xmlBody.getValue());
                    break;
                }
                case JSON: {
                    JsonBody jsonBody = (JsonBody)body;
                    this.bodyDTOMatcher = new JsonBodyDTO(jsonBody);
                    this.bodyMatcher = new JsonStringMatcher(this.mockServerLogger, jsonBody.getValue(), jsonBody.getMatchType());
                    break;
                }
                case JSON_SCHEMA: {
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)body;
                    this.bodyDTOMatcher = new JsonSchemaBodyDTO(jsonSchemaBody);
                    this.bodyMatcher = new JsonSchemaMatcher(this.mockServerLogger, jsonSchemaBody.getValue());
                    break;
                }
                case JSON_PATH: {
                    JsonPathBody jsonPathBody = (JsonPathBody)body;
                    this.bodyDTOMatcher = new JsonPathBodyDTO(jsonPathBody);
                    this.bodyMatcher = new JsonPathMatcher(this.mockServerLogger, jsonPathBody.getValue());
                    break;
                }
                case XML_SCHEMA: {
                    XmlSchemaBody xmlSchemaBody = (XmlSchemaBody)body;
                    this.bodyDTOMatcher = new XmlSchemaBodyDTO(xmlSchemaBody);
                    this.bodyMatcher = new XmlSchemaMatcher(this.mockServerLogger, xmlSchemaBody.getValue());
                    break;
                }
                case BINARY: {
                    BinaryBody binaryBody = (BinaryBody)body;
                    this.bodyDTOMatcher = new BinaryBodyDTO(binaryBody);
                    this.bodyMatcher = new BinaryMatcher(this.mockServerLogger, binaryBody.getValue());
                }
            }
            if (body.isNot()) {
                this.bodyMatcher = HttpRequestMatcher.not(this.bodyMatcher);
            }
        }
    }

    private void withHeaders(Headers headers) {
        this.headerMatcher = new MultiValueMapMatcher(this.mockServerLogger, headers, this.controlPlaneMatcher);
    }

    private void withCookies(Cookies cookies) {
        this.cookieMatcher = new HashMapMatcher(this.mockServerLogger, cookies, this.controlPlaneMatcher);
    }

    private void withKeepAlive(Boolean keepAlive) {
        this.keepAliveMatcher = new BooleanMatcher(this.mockServerLogger, keepAlive);
    }

    private void withSsl(Boolean isSsl) {
        this.sslMatcher = new BooleanMatcher(this.mockServerLogger, isSsl);
    }

    public boolean matches(HttpRequest request) {
        return this.matches((MatchDifference)null, request);
    }

    @Override
    public boolean matches(MatchDifference matchDifference, HttpRequest request) {
        StringBuilder becauseBuilder = new StringBuilder();
        boolean overallMatch = this.matches(matchDifference, request, becauseBuilder);
        if (!this.controlPlaneMatcher) {
            if (overallMatch) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_MATCHED).setLogLevel(Level.INFO).setHttpRequest(request).setExpectation(this.expectation).setMessageFormat(this.expectation == null ? REQUEST_DID_MATCH : EXPECTATION_DID_MATCH).setArguments(request, this.expectation == null ? this : this.expectation.clone()));
            } else {
                becauseBuilder.replace(0, 1, EMPTY);
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXPECTATION_NOT_MATCHED).setLogLevel(Level.INFO).setHttpRequest(request).setExpectation(this.expectation).setMessageFormat(this.expectation == null ? REQUEST_DID_NOT_MATCH : (becauseBuilder.length() > 0 ? EXPECTATION_DID_NOT_MATCH : EXPECTATION_DID_NOT_MATCH_WITHOUT_BECAUSE)).setArguments(request, this.expectation == null ? this : this.expectation.clone(), becauseBuilder.toString()));
            }
        }
        return overallMatch;
    }

    @Override
    public boolean isBlank() {
        return this.httpRequest == null;
    }

    private boolean matches(MatchDifference matchDifference, HttpRequest request, StringBuilder becauseBuilder) {
        if (this.isActive()) {
            if (request == this.httpRequest) {
                return true;
            }
            if (this.httpRequest == null) {
                return true;
            }
            if (matchDifference == null) {
                matchDifference = new MatchDifference(request);
            }
            if (request != null) {
                boolean pathMatches;
                boolean methodMatches;
                boolean bl = methodMatches = StringUtils.isBlank((CharSequence)request.getMethod().getValue()) || this.matches(METHOD, matchDifference, this.methodMatcher, request.getMethod());
                if (this.failFast(this.methodMatcher, matchDifference, becauseBuilder, methodMatches, METHOD, EMPTY)) {
                    return false;
                }
                boolean bl2 = pathMatches = StringUtils.isBlank((CharSequence)request.getPath().getValue()) || this.matches(PATH, matchDifference, this.pathMatcher, request.getPath());
                if (this.failFast(this.pathMatcher, matchDifference, becauseBuilder, pathMatches, PATH, EMPTY)) {
                    return false;
                }
                boolean bodyMatches = this.bodyMatches(matchDifference, request);
                if (this.failFast(this.bodyMatcher, matchDifference, becauseBuilder, bodyMatches, BODY, EMPTY)) {
                    return false;
                }
                boolean headersMatch = this.matches(HEADERS, matchDifference, this.headerMatcher, request.getHeaders());
                if (this.failFast(this.headerMatcher, matchDifference, becauseBuilder, headersMatch, HEADERS, EMPTY)) {
                    return false;
                }
                boolean cookiesMatch = this.matches(COOKIES, matchDifference, this.cookieMatcher, request.getCookies());
                if (this.failFast(this.cookieMatcher, matchDifference, becauseBuilder, cookiesMatch, COOKIES, EMPTY)) {
                    return false;
                }
                boolean queryStringParametersMatches = this.matches(QUERY, matchDifference, this.queryStringParameterMatcher, request.getQueryStringParameters());
                if (this.failFast(this.queryStringParameterMatcher, matchDifference, becauseBuilder, queryStringParametersMatches, QUERY, EMPTY)) {
                    return false;
                }
                boolean keepAliveMatches = this.matches(KEEP_ALIVE, matchDifference, this.keepAliveMatcher, request.isKeepAlive());
                if (this.failFast(this.keepAliveMatcher, matchDifference, becauseBuilder, keepAliveMatches, KEEP_ALIVE, EMPTY)) {
                    return false;
                }
                boolean sslMatches = this.matches(SSL_MATCHES, matchDifference, this.sslMatcher, request.isSecure());
                if (this.failFast(this.sslMatcher, matchDifference, becauseBuilder, sslMatches, SSL_MATCHES, EMPTY)) {
                    return false;
                }
                return HttpRequestMatcher.combinedResultAreTrue(matchDifference.getFailures() == 0, request.isNot(), this.httpRequest.isNot(), this.not);
            }
            return HttpRequestMatcher.combinedResultAreTrue(true, this.httpRequest.isNot(), this.not);
        }
        return false;
    }

    private boolean failFast(Matcher<?> matcher, MatchDifference matchDifference, StringBuilder becauseBuilder, boolean fieldMatches, String fieldName, String separator) {
        if (!this.controlPlaneMatcher) {
            becauseBuilder.append(separator).append(Character.NEW_LINE).append(fieldName).append(SPACE).append(fieldMatches ? MATCHED : DID_NOT_MATCH);
            if (matchDifference.getDifferences(fieldName) != null && !matchDifference.getDifferences(fieldName).isEmpty()) {
                becauseBuilder.append(": ").append(Character.NEW_LINE).append(Character.NEW_LINE).append(Joiner.on((String)Character.NEW_LINE).join(matchDifference.getDifferences(fieldName)));
            }
        }
        if (!fieldMatches && !this.controlPlaneMatcher) {
            if (matchDifference.getHttpRequest().isNot()) {
                becauseBuilder.append(COMMA).append(Character.NEW_LINE).append("request 'not' operator is enabled");
            }
            if (this.httpRequest.isNot()) {
                becauseBuilder.append(COMMA).append(Character.NEW_LINE).append("expectation's request 'not' operator is enabled");
            }
            if (this.not) {
                becauseBuilder.append(COMMA).append(Character.NEW_LINE).append("expectation's request matcher 'not' operator is enabled");
            }
        }
        if (!fieldMatches) {
            matchDifference.incrementFailures();
        }
        if (matcher != null && !matcher.isBlank() && ConfigurationProperties.matchersFailFast()) {
            return HttpRequestMatcher.combinedResultAreTrue(matchDifference.getFailures() != 0, matchDifference.getHttpRequest().isNot(), this.httpRequest.isNot(), this.not);
        }
        return false;
    }

    private static boolean combinedResultAreTrue(boolean ... inputs) {
        int count = 0;
        for (boolean input : inputs) {
            count += input ? 1 : 0;
        }
        return count % 2 != 0;
    }

    private boolean bodyMatches(MatchDifference context, HttpRequest request) {
        String bodyAsString;
        String string = bodyAsString = request.getBody() != null ? new String(request.getBody().getRawBytes(), request.getBody().getCharset(MediaType.DEFAULT_HTTP_CHARACTER_SET)) : EMPTY;
        boolean bodyMatches = this.bodyMatcher instanceof BinaryMatcher ? this.matches(BODY, context, this.bodyMatcher, request.getBodyAsRawBytes()) : (this.bodyMatcher instanceof ExactStringMatcher || this.bodyMatcher instanceof SubStringMatcher || this.bodyMatcher instanceof RegexStringMatcher || this.bodyMatcher instanceof XmlStringMatcher ? this.matches(BODY, context, this.bodyMatcher, NottableString.string(bodyAsString)) : this.matches(BODY, context, this.bodyMatcher, bodyAsString));
        if (!bodyMatches) {
            try {
                BodyDTO bodyDTO = (BodyDTO)this.objectMapper.readValue(bodyAsString, BodyDTO.class);
                bodyMatches = this.bodyDTOMatcher.equals(bodyDTO);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bodyMatches;
    }

    private <T> boolean matches(String fieldName, MatchDifference context, Matcher<T> matcher, T t) {
        if (context != null) {
            context.currentField(fieldName);
        }
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(context, t)) {
            result = true;
        }
        return result;
    }

    public boolean isActive() {
        return this.expectation == null || this.expectation.isActive();
    }

    @Override
    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]).writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

