/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.log.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lmax.disruptor.EventTranslator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.TimeService;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.LogEventBody;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.uuid.UUIDService;
import org.slf4j.event.Level;

public class LogEntry
extends ObjectWithJsonToString
implements EventTranslator<LogEntry> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
    private static final String[] EXCLUDED_FIELDS = new String[]{"id", "timestamp", "message", "throwable"};
    private String id;
    private Level logLevel = Level.INFO;
    public static final DateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private long epochTime = TimeService.currentTimeMillis();
    private String timestamp;
    private LogMessageType type;
    private HttpRequest[] httpRequests;
    private HttpRequest[] httpUpdatedRequests;
    private HttpResponse httpResponse;
    private HttpResponse httpUpdatedResponse;
    private HttpError httpError;
    private Expectation expectation;
    private Throwable throwable;
    private Runnable consumer;
    private MatchDifference matchDifference;
    private String messageFormat;
    private Object[] arguments;
    private String message;

    @JsonIgnore
    public String id() {
        if (this.id == null) {
            this.id = UUIDService.getUUID();
        }
        return this.id;
    }

    public void clear() {
        this.logLevel = Level.INFO;
        this.epochTime = -1L;
        this.httpRequests = new HttpRequest[]{HttpRequest.request()};
        this.timestamp = null;
        this.httpResponse = null;
        this.httpError = null;
        this.expectation = null;
        this.throwable = null;
        this.consumer = null;
        this.messageFormat = null;
        this.arguments = null;
        this.message = null;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public LogEntry setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        if (this.type == null) {
            this.type = LogMessageType.valueOf(logLevel.name());
        }
        return this;
    }

    public long getEpochTime() {
        return this.epochTime;
    }

    public LogEntry setEpochTime(long epochTime) {
        this.epochTime = epochTime;
        this.timestamp = null;
        return this;
    }

    public String getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = LOG_DATE_FORMAT.format(new Date(this.epochTime));
        }
        return this.timestamp;
    }

    public LogMessageType getType() {
        return this.type;
    }

    public LogEntry setType(LogMessageType type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public HttpRequest[] getHttpRequests() {
        if (this.httpRequests == null) {
            return new HttpRequest[0];
        }
        return this.httpRequests;
    }

    @JsonIgnore
    public HttpRequest[] getHttpUpdatedRequests() {
        if (this.httpRequests == null) {
            return new HttpRequest[0];
        }
        if (this.httpUpdatedRequests == null) {
            this.httpUpdatedRequests = (HttpRequest[])Arrays.stream(this.httpRequests).map(this::updateBody).toArray(HttpRequest[]::new);
            return this.httpUpdatedRequests;
        }
        return this.httpUpdatedRequests;
    }

    @JsonIgnore
    public boolean matches(HttpRequestMatcher matcher) {
        if (matcher == null) {
            return true;
        }
        if (this.httpRequests == null || this.httpRequests.length == 0) {
            return true;
        }
        for (HttpRequest httpRequest : this.httpRequests) {
            if (!matcher.matches(httpRequest)) continue;
            return true;
        }
        return false;
    }

    public LogEntry setHttpRequests(HttpRequest[] httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }

    public HttpRequest getHttpRequest() {
        if (this.httpRequests != null && this.httpRequests.length > 0) {
            return this.httpRequests[0];
        }
        return null;
    }

    public LogEntry setHttpRequest(HttpRequest httpRequest) {
        this.httpRequests = httpRequest != null ? new HttpRequest[]{httpRequest} : new HttpRequest[]{HttpRequest.request()};
        return this;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public HttpResponse getHttpUpdatedResponse() {
        if (this.httpResponse == null) {
            return null;
        }
        if (this.httpUpdatedResponse == null) {
            this.httpUpdatedResponse = this.updateBody(this.httpResponse);
            return this.httpUpdatedResponse;
        }
        return this.httpUpdatedResponse;
    }

    public LogEntry setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public LogEntry setHttpError(HttpError httpError) {
        this.httpError = httpError;
        return this;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public LogEntry setExpectation(Expectation expectation) {
        this.expectation = expectation;
        return this;
    }

    public LogEntry setExpectation(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.expectation = new Expectation(httpRequest, Times.once(), TimeToLive.unlimited(), 0).thenRespond(httpResponse);
        return this;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public LogEntry setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public Runnable getConsumer() {
        return this.consumer;
    }

    public LogEntry setConsumer(Runnable consumer) {
        this.consumer = consumer;
        return this;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public LogEntry setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public LogEntry setArguments(Object ... arguments) {
        this.arguments = arguments != null ? Arrays.stream(arguments).map(argument -> {
            if (argument instanceof HttpRequest) {
                return this.updateBody((HttpRequest)argument);
            }
            if (argument instanceof HttpResponse) {
                return this.updateBody((HttpResponse)argument);
            }
            return argument;
        }).toArray(Object[]::new) : null;
        if (this.matchDifference != null) {
            this.matchDifference.addDifference(this.messageFormat, arguments);
        }
        return this;
    }

    @JsonIgnore
    public String getMessage() {
        if (this.message == null) {
            this.message = this.arguments != null ? StringFormatter.formatLogMessage(this.messageFormat, this.arguments) : this.messageFormat;
        }
        return this.message;
    }

    public LogEntry setMatchDifference(MatchDifference matchDifference) {
        this.matchDifference = matchDifference;
        if (matchDifference != null) {
            this.setHttpRequest(matchDifference.getHttpRequest());
        }
        return this;
    }

    private HttpRequest updateBody(HttpRequest httpRequest) {
        if (httpRequest != null) {
            Body body = httpRequest.getBody();
            if (body != null && JsonBody.class.isAssignableFrom(body.getClass())) {
                try {
                    return httpRequest.clone().withBody(new LogEventBody(OBJECT_MAPPER.readTree(body.toString())));
                }
                catch (Throwable throwable) {
                    return httpRequest.clone().withBody(new LogEventBody(body.toString()));
                }
            }
            if (body != null && !(body instanceof LogEventBody) && BodyWithContentType.class.isAssignableFrom(body.getClass())) {
                return httpRequest.clone().withBody(new LogEventBody(body.toString()));
            }
            return httpRequest;
        }
        return null;
    }

    private HttpResponse updateBody(HttpResponse httpResponse) {
        if (httpResponse != null) {
            BodyWithContentType body = httpResponse.getBody();
            if (body != null && JsonBody.class.isAssignableFrom(body.getClass())) {
                try {
                    return httpResponse.clone().withBody(new LogEventBody(OBJECT_MAPPER.readTree(body.toString())));
                }
                catch (Throwable throwable) {
                    return httpResponse.clone().withBody(new LogEventBody(body.toString()));
                }
            }
            if (body != null && !(body instanceof LogEventBody)) {
                return httpResponse.clone().withBody(new LogEventBody(body.toString()));
            }
            return httpResponse;
        }
        return null;
    }

    public LogEntry clone() {
        return new LogEntry().setType(this.getType()).setLogLevel(this.getLogLevel()).setEpochTime(this.getEpochTime()).setHttpRequests(this.getHttpRequests()).setHttpResponse(this.getHttpResponse()).setHttpError(this.getHttpError()).setExpectation(this.getExpectation()).setMessageFormat(this.getMessageFormat()).setArguments(this.getArguments()).setThrowable(this.getThrowable()).setConsumer(this.getConsumer());
    }

    public void translateTo(LogEntry event, long sequence) {
        event.setType(this.getType()).setLogLevel(this.getLogLevel()).setEpochTime(this.getEpochTime()).setHttpRequests(this.getHttpRequests()).setHttpResponse(this.getHttpResponse()).setHttpError(this.getHttpError()).setExpectation(this.getExpectation()).setMessageFormat(this.getMessageFormat()).setArguments(this.getArguments()).setThrowable(this.getThrowable()).setConsumer(this.getConsumer());
        this.clear();
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }

    public static enum LogMessageType {
        RUNNABLE,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        EXCEPTION,
        CLEARED,
        RETRIEVED,
        UPDATED_EXPECTATION,
        CREATED_EXPECTATION,
        REMOVED_EXPECTATION,
        RECEIVED_REQUEST,
        EXPECTATION_RESPONSE,
        EXPECTATION_NOT_MATCHED_RESPONSE,
        EXPECTATION_MATCHED,
        EXPECTATION_NOT_MATCHED,
        VERIFICATION,
        VERIFICATION_FAILED,
        FORWARDED_REQUEST,
        TEMPLATE_GENERATED,
        SERVER_CONFIGURATION;

    }
}

