/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCallbackActionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HttpResponse handle(HttpClassCallback httpClassCallback, HttpRequest httpRequest) {
        return this.invokeCallbackMethod(httpClassCallback, httpRequest);
    }

    private ExpectationCallback instantiateCallback(HttpClassCallback httpClassCallback) {
        try {
            Class<?> expectationCallbackClass = Class.forName(httpClassCallback.getCallbackClass());
            if (ExpectationCallback.class.isAssignableFrom(expectationCallbackClass)) {
                Constructor<?> constructor = expectationCallbackClass.getConstructor(new Class[0]);
                return (ExpectationCallback)constructor.newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.error("ClassNotFoundException - while trying to instantiate ExpectationCallback class \"" + httpClassCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.logger.error("NoSuchMethodException - while trying to create default constructor on ExpectationCallback class \"" + httpClassCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.error("InvocationTargetException - while trying to execute default constructor on ExpectationCallback class \"" + httpClassCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.logger.error("InvocationTargetException - while trying to execute default constructor on ExpectationCallback class \"" + httpClassCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("InvocationTargetException - while trying to execute default constructor on ExpectationCallback class \"" + httpClassCallback.getCallbackClass() + "\"", (Throwable)e);
        }
        return null;
    }

    private HttpResponse invokeCallbackMethod(HttpClassCallback httpClassCallback, HttpRequest httpRequest) {
        if (httpRequest != null) {
            ExpectationCallback expectationCallback = this.instantiateCallback(httpClassCallback);
            if (expectationCallback != null) {
                return expectationCallback.handle(httpRequest);
            }
            return HttpResponse.notFoundResponse();
        }
        return HttpResponse.notFoundResponse();
    }
}

