/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import com.google.common.base.Strings;
import java.util.List;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.client.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.filters.RequestResponseLogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.HttpRequest;
import org.slf4j.LoggerFactory;

public class HttpStateHandler {
    private LogFormatter logFormatter = new LogFormatter(LoggerFactory.getLogger(this.getClass()));
    private final RequestLogFilter requestLogFilter;
    private final RequestResponseLogFilter requestResponseLogFilter;
    private final MockServerMatcher mockServerMatcher;
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestToJavaSerializer httpRequestToJavaSerializer = new HttpRequestToJavaSerializer();
    private ExpectationToJavaSerializer expectationToJavaSerializer = new ExpectationToJavaSerializer();

    public HttpStateHandler(RequestLogFilter requestLogFilter, RequestResponseLogFilter requestResponseLogFilter, MockServerMatcher mockServerMatcher) {
        this.requestLogFilter = requestLogFilter;
        this.requestResponseLogFilter = requestResponseLogFilter;
        this.mockServerMatcher = mockServerMatcher;
    }

    public void clear(HttpRequest request) {
        HttpRequest httpRequest = null;
        if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
            httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        if (request.hasQueryStringParameter("type", "expectation")) {
            if (this.mockServerMatcher != null) {
                this.mockServerMatcher.clear(httpRequest);
            }
            if (this.requestResponseLogFilter != null) {
                this.requestResponseLogFilter.clear(httpRequest);
            }
            this.logFormatter.infoLog("clearing expectations that match:{}", httpRequest);
        } else if (request.hasQueryStringParameter("type", "log")) {
            this.requestLogFilter.clear(httpRequest);
            this.logFormatter.infoLog("clearing request logs that match:{}", httpRequest);
        } else {
            if (this.mockServerMatcher != null) {
                this.mockServerMatcher.clear(httpRequest);
            }
            if (this.requestResponseLogFilter != null) {
                this.requestResponseLogFilter.clear(httpRequest);
            }
            this.requestLogFilter.clear(httpRequest);
            this.logFormatter.infoLog("clearing expectations and request logs that match:{}", httpRequest);
        }
    }

    public String retrieve(HttpRequest request) {
        HttpRequest httpRequest = null;
        if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
            httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        StringBuilder responseBody = new StringBuilder();
        boolean asJava = request.hasQueryStringParameter("format", "java");
        boolean asExpectations = request.hasQueryStringParameter("type", "expectation");
        if (asExpectations) {
            List<Expectation> expectations = this.mockServerMatcher.retrieveExpectations(httpRequest);
            if (asJava) {
                responseBody.append(this.expectationToJavaSerializer.serializeAsJava(0, expectations));
            } else {
                responseBody.append(this.expectationSerializer.serialize(expectations));
            }
        } else {
            List<HttpRequest> httpRequests = this.requestLogFilter.retrieve(httpRequest);
            if (asJava) {
                responseBody.append(this.httpRequestToJavaSerializer.serializeAsJava(0, httpRequests));
            } else {
                responseBody.append(this.httpRequestSerializer.serialize(httpRequests));
            }
        }
        this.logFormatter.infoLog("retrieving " + (asExpectations ? "expectations" : "requests") + " that match:{}", httpRequest);
        return responseBody.toString();
    }

    public void dumpRecordedRequestResponsesToLog(HttpRequest request) {
        HttpRequest httpRequest = null;
        if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
            httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        boolean asJava = request.hasQueryStringParameter("type", "java") || request.hasQueryStringParameter("format", "java");
        this.requestResponseLogFilter.dumpToLog(httpRequest, asJava);
        this.logFormatter.infoLog("dumped all requests and responses to the log in " + (asJava ? "java" : "json") + " that match:{}", httpRequest);
    }

    public void dumpExpectationsToLog(HttpRequest request) {
        HttpRequest httpRequest = null;
        if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
            httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        boolean asJava = request.hasQueryStringParameter("type", "java") || request.hasQueryStringParameter("format", "java");
        this.mockServerMatcher.dumpToLog(httpRequest, asJava);
        this.logFormatter.infoLog("dumped all active expectations to the log in " + (asJava ? "java" : "json") + " that match:{}", httpRequest);
    }

    public void reset() {
        if (this.mockServerMatcher != null) {
            this.mockServerMatcher.reset();
        }
        if (this.requestResponseLogFilter != null) {
            this.requestResponseLogFilter.reset();
        }
        this.requestLogFilter.reset();
        this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
    }
}

