/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.slf4j.Logger;

public class LogFormatter {
    private final Logger logger;

    public LogFormatter(Logger logger) {
        this.logger = logger;
    }

    public void traceLog(String message, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message + Character.NEW_LINE, (Object[])StringFormatter.indentAndToString(arguments));
        }
    }

    public void infoLog(String message, Object ... arguments) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message + Character.NEW_LINE, (Object[])StringFormatter.indentAndToString(arguments));
        }
    }

    public void errorLog(String message, Object ... arguments) {
        this.logger.error(this.formatLogMessage(message, arguments).toString());
    }

    public void errorLog(Throwable throwable, String message, Object ... arguments) {
        this.logger.error(this.formatLogMessage(message, arguments).toString(), throwable);
    }

    public StringBuilder formatLogMessage(String message, Object ... arguments) {
        StringBuilder errorMessage = new StringBuilder();
        String[] formattedArguments = StringFormatter.indentAndToString(arguments);
        String[] messageParts = (message + Character.NEW_LINE).split("\\{\\}");
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            errorMessage.append(messageParts[messagePartIndex]);
            if (formattedArguments.length <= messagePartIndex) continue;
            errorMessage.append((Object)formattedArguments[messagePartIndex]);
        }
        return errorMessage;
    }
}

