/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import org.mockserver.collections.CircularMultiMap;
import org.mockserver.filters.Filter;
import org.mockserver.filters.RequestFilter;
import org.mockserver.filters.ResponseFilter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class Filters {
    private final CircularMultiMap<HttpRequestMatcher, ResponseFilter> responseFilters = new CircularMultiMap(100, 100);
    private final CircularMultiMap<HttpRequestMatcher, RequestFilter> requestFilters = new CircularMultiMap(100, 100);
    private final MatcherBuilder matcherBuilder = new MatcherBuilder();

    public Filters withFilter(HttpRequest httpRequest, Filter filter) {
        if (filter instanceof RequestFilter) {
            this.requestFilters.put(this.matcherBuilder.transformsToMatcher(httpRequest), (RequestFilter)filter);
        }
        if (filter instanceof ResponseFilter) {
            this.responseFilters.put(this.matcherBuilder.transformsToMatcher(httpRequest), (ResponseFilter)filter);
        }
        return this;
    }

    public HttpRequest applyOnRequestFilters(HttpRequest httpRequest) {
        for (HttpRequestMatcher httpRequestMatcher : this.requestFilters.keySet()) {
            if (!httpRequestMatcher.matches(httpRequest)) continue;
            for (RequestFilter requestFilter : this.requestFilters.getAll(httpRequestMatcher)) {
                if (httpRequest == null) continue;
                httpRequest = requestFilter.onRequest(httpRequest);
            }
        }
        return httpRequest;
    }

    public HttpResponse applyOnResponseFilters(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpResponse != null) {
            for (HttpRequestMatcher httpRequestMatcher : this.responseFilters.keySet()) {
                if (!httpRequestMatcher.matches(httpRequest)) continue;
                for (ResponseFilter proxyFilter : this.responseFilters.getAll(httpRequestMatcher)) {
                    httpResponse = proxyFilter.onResponse(httpRequest, httpResponse);
                    if (httpResponse != null) continue;
                    throw new IllegalStateException(proxyFilter.getClass().getName() + " returned a null HttpResponse, Filters are not allowed to return a null HttpResponse object, a Filter can only return null for an HttpRequest which will prevent the request being sent.");
                }
            }
        }
        return httpResponse;
    }
}

