/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import org.mockserver.client.serialization.model.DTO;
import org.mockserver.client.serialization.model.DelayDTO;
import org.mockserver.model.HttpTemplate;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class HttpTemplateDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpTemplate> {
    private String template;
    private HttpTemplate.TemplateType templateType;
    private DelayDTO delay;

    public HttpTemplateDTO(HttpTemplate httpTemplate) {
        if (httpTemplate != null) {
            this.templateType = httpTemplate.getTemplateType();
            this.template = httpTemplate.getTemplate();
            this.delay = httpTemplate.getDelay() != null ? new DelayDTO(httpTemplate.getDelay()) : null;
        }
    }

    public HttpTemplateDTO() {
    }

    @Override
    public HttpTemplate buildObject() {
        return new HttpTemplate(this.templateType).withTemplate(this.template).withDelay(this.delay != null ? this.delay.buildObject() : null);
    }

    public HttpTemplate.TemplateType getTemplateType() {
        return this.templateType;
    }

    public HttpTemplateDTO setTemplateType(HttpTemplate.TemplateType templateType) {
        this.templateType = templateType;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public HttpTemplateDTO setTemplate(String template) {
        this.template = template;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpTemplateDTO setDelay(DelayDTO delay) {
        this.delay = delay;
        return this;
    }
}

