/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import org.mockserver.client.serialization.model.DTO;
import org.mockserver.client.serialization.model.DelayDTO;
import org.mockserver.model.HttpError;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class HttpErrorDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpError> {
    private DelayDTO delay;
    private Boolean dropConnection;
    private byte[] responseBytes;

    public HttpErrorDTO(HttpError httpError) {
        if (httpError != null) {
            if (httpError.getDelay() != null) {
                this.delay = new DelayDTO(httpError.getDelay());
            }
            this.dropConnection = httpError.getDropConnection();
            this.responseBytes = httpError.getResponseBytes();
        }
    }

    public HttpErrorDTO() {
    }

    @Override
    public HttpError buildObject() {
        return new HttpError().withDelay(this.delay != null ? this.delay.buildObject() : null).withDropConnection(this.dropConnection).withResponseBytes(this.responseBytes);
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpErrorDTO setDelay(DelayDTO host) {
        this.delay = host;
        return this;
    }

    public Boolean getDropConnection() {
        return this.dropConnection;
    }

    public HttpErrorDTO setDropConnection(Boolean port) {
        this.dropConnection = port;
        return this;
    }

    public byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public HttpErrorDTO setResponseBytes(byte[] scheme) {
        this.responseBytes = scheme;
        return this;
    }
}

