/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import org.mockserver.character.Character;
import org.slf4j.Logger;

public class LogFormatter {
    private final Logger logger;

    public LogFormatter(Logger logger) {
        this.logger = logger;
    }

    public void traceLog(String message, Object ... objects) {
        if (this.logger.isTraceEnabled()) {
            Object[] indentedObjects = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                indentedObjects[i] = Character.NEW_LINE + Character.NEW_LINE + String.valueOf(objects[i]).replaceAll("(?m)^", "\t") + Character.NEW_LINE;
            }
            this.logger.trace(message + Character.NEW_LINE, indentedObjects);
        }
    }

    public void infoLog(String message, Object ... objects) {
        if (this.logger.isInfoEnabled()) {
            Object[] indentedObjects = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                indentedObjects[i] = Character.NEW_LINE + Character.NEW_LINE + String.valueOf(objects[i]).replaceAll("(?m)^", "\t") + Character.NEW_LINE;
            }
            this.logger.info(message + Character.NEW_LINE, indentedObjects);
        }
    }
}

