/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.file;

import com.google.common.base.Charsets;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class FileReader {
    public static String readFileFromClassPathOrPath(String filePath) {
        try {
            return IOUtils.toString((InputStream)FileReader.openStreamToFileFromClassPathOrPath(filePath), (String)Charsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while loading \"" + filePath + "\"");
        }
    }

    public static InputStream openStreamToFileFromClassPathOrPath(String filename) throws FileNotFoundException {
        InputStream inputStream = FileReader.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream == null) {
            inputStream = new FileInputStream(filename);
        }
        return inputStream;
    }

    public static Reader openReaderToFileFromClassPathOrPath(String filename) throws FileNotFoundException {
        return new InputStreamReader(FileReader.openStreamToFileFromClassPathOrPath(filename));
    }
}

