/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.mockserver.model.HttpResponse;

public class HttpClientConnectionHandler
extends ChannelDuplexHandler {
    private final SettableFuture<HttpResponse> responseFuture;

    public HttpClientConnectionHandler(SettableFuture<HttpResponse> responseFuture) {
        this.responseFuture = responseFuture;
    }

    private void updatePromise(String action) {
        if (!this.responseFuture.isDone()) {
            this.responseFuture.setException((Throwable)new RuntimeException("Channel " + action + " before valid response has been received"));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.updatePromise("set as inactive");
        super.channelInactive(ctx);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.updatePromise("disconnected");
        super.disconnect(ctx, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.updatePromise("closed");
        super.close(ctx, promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.updatePromise("deregistered");
        super.deregister(ctx, promise);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.updatePromise("unregistered");
        super.channelUnregistered(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.updatePromise("handler removed");
        super.handlerRemoved(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.responseFuture.isDone()) {
            this.responseFuture.setException((Throwable)new RuntimeException("Exception caught before valid response has been received", cause));
        }
        super.exceptionCaught(ctx, cause);
    }
}

