/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server.unification;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import org.mockserver.server.unification.HttpContentLengthRemover;
import org.mockserver.socket.NettySslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class PortUnificationHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    public static final AttributeKey<Boolean> SSL_ENABLED = AttributeKey.valueOf((String)"SSL_ENABLED");
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public PortUnificationHandler() {
        super(false);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (msg.readableBytes() < 3) {
            return;
        }
        if (this.isSsl(msg)) {
            this.enableSsl(ctx, msg);
        } else if (this.isHttp(msg)) {
            this.switchToHttp(ctx, msg);
        } else {
            msg.clear();
            ctx.close();
        }
        if (this.logger.isTraceEnabled()) {
            if (ctx.pipeline().get(org.mockserver.logging.LoggingHandler.class) != null) {
                ctx.pipeline().remove(org.mockserver.logging.LoggingHandler.class);
            }
            if (ctx.pipeline().get(SslHandler.class) != null) {
                ctx.pipeline().addAfter("SslHandler#0", "LoggingHandler#0", (ChannelHandler)new org.mockserver.logging.LoggingHandler(this.logger));
            } else {
                ctx.pipeline().addFirst(new ChannelHandler[]{new org.mockserver.logging.LoggingHandler(this.logger)});
            }
        }
    }

    private boolean isSsl(ByteBuf buf) {
        return buf.readableBytes() >= 5 && SslHandler.isEncrypted((ByteBuf)buf);
    }

    private boolean isHttp(ByteBuf msg) {
        short letterOne = msg.getUnsignedByte(msg.readerIndex());
        short letterTwo = msg.getUnsignedByte(msg.readerIndex() + 1);
        short letterThree = msg.getUnsignedByte(msg.readerIndex() + 2);
        return letterOne == 71 && letterTwo == 69 && letterThree == 84 || letterOne == 80 && letterTwo == 79 && letterThree == 83 || letterOne == 80 && letterTwo == 85 && letterThree == 84 || letterOne == 72 && letterTwo == 69 && letterThree == 65 || letterOne == 79 && letterTwo == 80 && letterThree == 84 || letterOne == 80 && letterTwo == 65 && letterThree == 84 || letterOne == 68 && letterTwo == 69 && letterThree == 76 || letterOne == 84 && letterTwo == 82 && letterThree == 65 || letterOne == 67 && letterTwo == 79 && letterThree == 78;
    }

    private void enableSsl(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addFirst(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createServerSslContext().newHandler(ctx.alloc())});
        ctx.channel().attr(SSL_ENABLED).set((Object)Boolean.TRUE);
        ctx.pipeline().fireChannelRead((Object)msg);
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpServerCodec());
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpContentDecompressor());
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpContentLengthRemover());
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
        if (this.logger.isDebugEnabled()) {
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new LoggingHandler());
        }
        this.configurePipeline(ctx, pipeline);
        pipeline.remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)msg);
    }

    protected void addLastIfNotPresent(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.get(channelHandler.getClass()) == null) {
            pipeline.addLast(new ChannelHandler[]{channelHandler});
        }
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, ChannelPipeline var2);
}

