/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.List;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeyToMultiValue;

public class MultiValueMapMatcher
extends NotMatcher<List<KeyToMultiValue>> {
    private final CaseInsensitiveRegexMultiMap multiMap;

    public MultiValueMapMatcher(CaseInsensitiveRegexMultiMap multiMap) {
        this.multiMap = multiMap;
    }

    @Override
    public boolean matches(List<KeyToMultiValue> values) {
        boolean result = false;
        if (this.multiMap == null) {
            result = true;
        } else if (KeyToMultiValue.toMultiMap(values).containsAll(this.multiMap)) {
            result = true;
        } else {
            this.logger.trace("Map [{}] is not a subset of [{}]", (Object)this.multiMap, (Object)KeyToMultiValue.toMultiMap(values));
        }
        return this.reverseResultIfNot(result);
    }
}

