/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.mockserver.filters.RequestFilter;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;

public class HopByHopHeaderFilter
implements RequestFilter {
    public HttpRequest onRequest(HttpRequest httpRequest) {
        if (httpRequest != null) {
            List<String> headersToRemove = Arrays.asList("proxy-connection", "connection", "keep-alive", "transfer-encoding", "te", "trailer", "proxy-authorization", "proxy-authenticate", "upgrade");
            ArrayList<Header> filteredHeaders = new ArrayList<Header>();
            for (Header header : httpRequest.getHeaders()) {
                if (headersToRemove.contains(header.getName().getValue().toLowerCase(Locale.ENGLISH))) continue;
                filteredHeaders.add(header);
            }
            return httpRequest.withHeaders(filteredHeaders);
        }
        return null;
    }
}

