/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.serializers.body;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.model.StringBody;

public class StringBodySerializer
extends StdSerializer<StringBody> {
    public StringBodySerializer() {
        super(StringBody.class);
    }

    public void serialize(StringBody stringBody, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        boolean contentTypeFieldSet;
        boolean notFieldSetAndNonDefault = stringBody.getNot() != null && stringBody.getNot() != false;
        boolean bl = contentTypeFieldSet = stringBody.getContentType() != null;
        if (notFieldSetAndNonDefault || contentTypeFieldSet) {
            jgen.writeStartObject();
            if (notFieldSetAndNonDefault) {
                jgen.writeBooleanField("not", true);
            }
            if (contentTypeFieldSet) {
                jgen.writeStringField("contentType", stringBody.getContentType());
            }
            jgen.writeStringField("type", stringBody.getType().name());
            jgen.writeStringField("string", stringBody.getValue());
            jgen.writeEndObject();
        } else {
            jgen.writeString(stringBody.getValue());
        }
    }
}

