/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.HttpClassCallback;

public class HttpCallbackToJavaSerializer
implements ToJavaSerializer<HttpClassCallback> {
    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, HttpClassCallback httpClassCallback) {
        StringBuffer output = new StringBuffer();
        if (httpClassCallback != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("callback()");
            if (httpClassCallback.getCallbackClass() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCallbackClass(\"").append(httpClassCallback.getCallbackClass()).append("\")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(System.getProperty("line.separator")).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

