/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLException;
import org.mockserver.client.netty.HttpClientHandler;
import org.mockserver.client.netty.codec.MockServerClientCodec;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.model.HttpResponse;
import org.mockserver.socket.NettySslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final boolean secure;
    private final InetSocketAddress remoteAddress;
    private HttpClientHandler httpClientHandler = new HttpClientHandler();

    public HttpClientInitializer(boolean secure, InetSocketAddress remoteAddress) {
        this.secure = secure;
        this.remoteAddress = remoteAddress;
    }

    public void initChannel(SocketChannel channel) throws SSLException {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.secure) {
            pipeline.addLast(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createClientSslContext().newHandler(channel.alloc(), this.remoteAddress.getHostName(), this.remoteAddress.getPort())});
        }
        if (this.logger.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("NettyHttpClient -->")});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerClientCodec()});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
    }

    public SettableFuture<HttpResponse> getResponseFuture() {
        return this.httpClientHandler.getResponseFuture();
    }
}

