/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.Body;

public class StringBody
extends Body<String> {
    private final String value;
    private final byte[] rawBinaryData;
    private final Charset charset;

    public StringBody(String value) {
        this(value, null);
    }

    public StringBody(String value, Charset charset) {
        super(Body.Type.STRING);
        this.value = value;
        this.charset = charset;
        this.rawBinaryData = value != null ? value.getBytes(charset != null ? charset : ContentTypeMapper.DEFAULT_HTTP_CHARACTER_SET) : new byte[0];
    }

    public static StringBody exact(String body) {
        return new StringBody(body);
    }

    public static StringBody exact(String body, Charset charset) {
        return new StringBody(body, charset);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public byte[] getRawBytes() {
        return this.rawBinaryData;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        return this.charset != null ? this.charset : defaultIfNotSet;
    }

    @Override
    @JsonIgnore
    public String getContentType() {
        return MediaType.create((String)"text", (String)"plain").toString();
    }

    @Override
    public String toString() {
        return this.value;
    }
}

