/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.model.Body;

public class BinaryBody
extends Body<byte[]> {
    private final byte[] bytes;

    public BinaryBody(byte[] bytes) {
        super(Body.Type.BINARY);
        this.bytes = bytes;
    }

    public static BinaryBody binary(byte[] body) {
        return new BinaryBody(body);
    }

    @Override
    public byte[] getValue() {
        return this.bytes;
    }

    @Override
    public byte[] getRawBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        return this.bytes != null ? Base64Converter.bytesToBase64String(this.bytes) : null;
    }
}

