/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.collections.CircularMultiMap;
import org.mockserver.filters.RequestFilter;
import org.mockserver.filters.ResponseFilter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResponseLogFilter
implements ResponseFilter,
RequestFilter {
    private final CircularMultiMap<HttpRequest, HttpResponse> requestResponseLog = new CircularMultiMap(100, 50);
    private final MatcherBuilder matcherBuilder = new MatcherBuilder();
    private Logger requestLogger = LoggerFactory.getLogger((String)"REQUEST");

    @Override
    public HttpResponse onResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpRequest != null && httpResponse != null) {
            this.requestResponseLog.put(httpRequest, httpResponse);
        } else if (httpRequest != null) {
            this.requestResponseLog.put(httpRequest, HttpResponse.notFoundResponse());
        }
        return httpResponse;
    }

    public HttpRequest onRequest(HttpRequest httpRequest) {
        return httpRequest;
    }

    public List<HttpResponse> httpResponses(HttpRequest httpRequest) {
        ArrayList<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequest loggedHttpRequest : new LinkedList<HttpRequest>(this.requestResponseLog.keySet())) {
            if (!httpRequestMatcher.matches(loggedHttpRequest)) continue;
            httpResponses.addAll(this.requestResponseLog.getAll(loggedHttpRequest));
        }
        return httpResponses;
    }

    public void reset() {
        this.requestResponseLog.clear();
    }

    public void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequest key : new LinkedList<HttpRequest>(this.requestResponseLog.keySet())) {
                if (!httpRequestMatcher.matches(key)) continue;
                this.requestResponseLog.removeAll(key);
            }
        } else {
            this.reset();
        }
    }

    public void dumpToLog(HttpRequest httpRequest, boolean asJava) {
        ExpectationSerializer expectationSerializer = new ExpectationSerializer();
        ExpectationToJavaSerializer expectationToJavaSerializer = new ExpectationToJavaSerializer();
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (Map.Entry<HttpRequest, HttpResponse> entry : this.requestResponseLog.entrySet()) {
                if (!httpRequestMatcher.matches(entry.getKey(), true)) continue;
                if (asJava) {
                    this.requestLogger.warn(expectationToJavaSerializer.serializeAsJava(0, new Expectation(entry.getKey(), Times.once(), TimeToLive.unlimited()).thenRespond(entry.getValue())));
                    continue;
                }
                this.requestLogger.warn(expectationSerializer.serialize(new Expectation(entry.getKey(), Times.once(), TimeToLive.unlimited()).thenRespond(entry.getValue())));
            }
        } else {
            for (Map.Entry<HttpRequest, HttpResponse> entry : this.requestResponseLog.entrySet()) {
                if (asJava) {
                    this.requestLogger.warn(expectationToJavaSerializer.serializeAsJava(0, new Expectation(entry.getKey(), Times.once(), TimeToLive.unlimited()).thenRespond(entry.getValue())));
                    continue;
                }
                this.requestLogger.warn(expectationSerializer.serialize(new Expectation(entry.getKey(), Times.once(), TimeToLive.unlimited()).thenRespond(entry.getValue())));
            }
        }
    }
}

