/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import java.nio.charset.Charset;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;

public class JsonBodyDTO
extends BodyDTO {
    private String json;
    private MatchType matchType;
    private Charset charset;

    public JsonBodyDTO(JsonBody jsonBody) {
        this(jsonBody, (Boolean)false);
    }

    public JsonBodyDTO(JsonBody jsonBody, Boolean not) {
        super(Body.Type.JSON, not);
        this.json = jsonBody.getValue();
        this.matchType = jsonBody.getMatchType();
        this.charset = jsonBody.getCharset();
    }

    protected JsonBodyDTO() {
    }

    public String getJson() {
        return this.json;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public JsonBody buildObject() {
        return new JsonBody(this.getJson(), this.charset, this.matchType);
    }
}

