/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import org.mockserver.client.serialization.model.HttpCallbackDTO;
import org.mockserver.client.serialization.model.HttpErrorDTO;
import org.mockserver.client.serialization.model.HttpForwardDTO;
import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.client.serialization.model.HttpResponseDTO;
import org.mockserver.client.serialization.model.TimeToLiveDTO;
import org.mockserver.client.serialization.model.TimesDTO;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithJsonToString;

public class ExpectationDTO
extends ObjectWithJsonToString {
    private HttpRequestDTO httpRequest;
    private HttpResponseDTO httpResponse;
    private HttpForwardDTO httpForward;
    private HttpErrorDTO httpError;
    private HttpCallbackDTO httpCallback;
    private TimesDTO times;
    private TimeToLiveDTO timeToLive;

    public ExpectationDTO(Expectation expectation) {
        if (expectation != null) {
            TimeToLive timeToLive;
            Times times;
            HttpCallback httpCallback;
            HttpError httpError;
            HttpForward httpForward;
            HttpResponse httpResponse;
            HttpRequest httpRequest = expectation.getHttpRequest();
            if (httpRequest != null) {
                this.httpRequest = new HttpRequestDTO(httpRequest, httpRequest.getNot());
            }
            if ((httpResponse = expectation.getHttpResponse(false)) != null) {
                this.httpResponse = new HttpResponseDTO(httpResponse);
            }
            if ((httpForward = expectation.getHttpForward()) != null) {
                this.httpForward = new HttpForwardDTO(httpForward);
            }
            if ((httpError = expectation.getHttpError()) != null) {
                this.httpError = new HttpErrorDTO(httpError);
            }
            if ((httpCallback = expectation.getHttpCallback()) != null) {
                this.httpCallback = new HttpCallbackDTO(httpCallback);
            }
            if ((times = expectation.getTimes()) != null) {
                this.times = new TimesDTO(times);
            }
            if ((timeToLive = expectation.getTimeToLive()) != null) {
                this.timeToLive = new TimeToLiveDTO(timeToLive);
            }
        }
    }

    public ExpectationDTO() {
    }

    public Expectation buildObject() {
        HttpRequest httpRequest = null;
        HttpResponse httpResponse = null;
        HttpForward httpForward = null;
        HttpError httpError = null;
        HttpCallback httpCallback = null;
        if (this.httpRequest != null) {
            httpRequest = this.httpRequest.buildObject();
        }
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        if (this.httpForward != null) {
            httpForward = this.httpForward.buildObject();
        }
        if (this.httpError != null) {
            httpError = this.httpError.buildObject();
        }
        if (this.httpCallback != null) {
            httpCallback = this.httpCallback.buildObject();
        }
        Times times = this.times != null ? this.times.buildObject() : Times.once();
        TimeToLive timeToLive = this.timeToLive != null ? this.timeToLive.buildObject() : TimeToLive.unlimited();
        return new Expectation(httpRequest, times, timeToLive).thenRespond(httpResponse).thenForward(httpForward).thenError(httpError).thenCallback(httpCallback);
    }

    public HttpRequestDTO getHttpRequest() {
        return this.httpRequest;
    }

    public ExpectationDTO setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public ExpectationDTO setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpForwardDTO getHttpForward() {
        return this.httpForward;
    }

    public ExpectationDTO setHttpForward(HttpForwardDTO httpForward) {
        this.httpForward = httpForward;
        return this;
    }

    public HttpErrorDTO getHttpError() {
        return this.httpError;
    }

    public ExpectationDTO setHttpError(HttpErrorDTO httpError) {
        this.httpError = httpError;
        return this;
    }

    public HttpCallbackDTO getHttpCallback() {
        return this.httpCallback;
    }

    public ExpectationDTO setHttpCallback(HttpCallbackDTO httpCallback) {
        this.httpCallback = httpCallback;
        return this;
    }

    public TimesDTO getTimes() {
        return this.times;
    }

    public ExpectationDTO setTimes(TimesDTO times) {
        this.times = times;
        return this;
    }

    public TimeToLiveDTO getTimeToLive() {
        return this.timeToLive;
    }

    public ExpectationDTO setTimeToLive(TimeToLiveDTO timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }
}

