/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.HttpForward;

public class HttpForwardToJavaSerializer
implements ToJavaSerializer<HttpForward> {
    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, HttpForward httpForward) {
        StringBuffer output = new StringBuffer();
        if (httpForward != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("forward()");
            if (httpForward.getHost() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withHost(\"").append(httpForward.getHost()).append("\")");
            }
            if (httpForward.getPort() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withPort(").append(httpForward.getPort()).append(")");
            }
            if (httpForward.getScheme() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withScheme(HttpForward.Scheme.").append((Object)httpForward.getScheme()).append(")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(System.getProperty("line.separator")).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

